/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)sleep.c	1.3 84/11/06
*/

/*
**	Own version of sleep(3).
*/

#include	"global.h"

#include	<signal.h>
#include	<setjmp.h>


jmp_buf		Sleep_jmp;



unsigned
sleep(seconds)
	unsigned int		seconds;
{
	register unsigned int	secs;
	int			(*old_sig)();
	extern int		sleep_catch();

	if ( (secs = seconds) == 0 )
		return 0;

	old_sig = signal(SIGALRM, sleep_catch);

	if ( !setjmp(Sleep_jmp) )
	{
		unsigned int	i;

		if ( i = alarm(seconds) )
			Warn("sleep called with alarm already set to %d", i);

		pause();

		(void)alarm(0);	/* Interrupted... */
	}

	(void)signal(SIGALRM, old_sig);
}



int
sleep_catch(sig)
	int	sig;
{
	longjmp(Sleep_jmp, 1);
}
