/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)WrStats.c	1.1 84/06/12
*/

/*
**	Write out a statistics record.
*/

#define	LOCKING
#define	STDIO

#include	"global.h"
#include	"debug.h"
#include	"stats.h"



void
WrStats(id, funcp)
	char		id;
	bool		(*funcp)();	/* Caller supplied function to write a field */
{
	register FILE *	fd;
	register int	i;

	if
	(
		access(STATSFILE, 0) == SYSERROR
		||
		(fd = fopen(STATSFILE, "a")) == NULL
	)
	{
		Trace3(1, "Can't open %s, errno %d", STATSFILE, errno);
		return;
	}

#	if	AUTO_LOCKING != 1
	if ( Lock(STATSFILE, fileno(fd), for_writing) == SYSERROR )
		return;
#	endif	AUTO_LOCKING != 1

	(void)fseek(fd, 0L, 2);

	putc(id, fd);

	i = 0;

	do
		putc(ST_RE_SEP, fd);
	while
		( (*funcp)(fd, i++) );

	putc(ST_SEP, fd);

#	if	AUTO_LOCKING != 1
	(void)fflush(fd);
	UnLock(fileno(fd));
#	endif	AUTO_LOCKING != 1

	(void)fclose(fd);
}
