(***********************************************************************

Name:		BaseName.Pas
Version:	1.0

     This software has been placed into the public domain by Digital
			 Equipment Corporation.


DISCLAIMER:

The information herein is subject to change without  notice  and  should
not be construed as a commitment by Digital Equipment Corporation.

Digital Equipment Corporation assumes no responsibility for the  use  or
reliability  of  this  software.   This  software  is  provided "as is,"
without any warranty of any kind, express or implied.  Digital Equipment
Corporation  will  not	be liable in any event for any damages including
any loss of data, profit, or savings, claims against  the  user  by  any
other  party,  or  any other incidental or consequential damages arising
out of the use of, or inability to use, this software, even  if  Digital
Equipment Corporation is advised of the possibility of such damage.

DEFECT REPORTING AND SUGGESTIONS:

Please send reports of defects or suggestions for  improvement	directly
to the author:

	Brian Hetrick
	Digital Equipment Corporation
	110 Spit Brook Road  ZKO1-3/J10
	Nashua NH  03062-2698

Do NOT file a Software Performance Report on  this  software,  call  the
Telephone  Support  Center regarding this software, contact your Digital
Field Office  regarding  this  software,  or  use  any	other  mechanism
provided for Digital's supported and warranted software.


FACILITY:

    TURBO Pascal MS-DOS support routines

ABSTRACT:

    Obtains the last component of a path specification

ENVIRONMENT:

    MS-DOS V2.0 or later, compiled with  Borland  International's  TURBO
    Pascal V3.0 or later.

AUTHOR: Brian Hetrick, CREATION DATE: 2 December 1986.

MODIFIED BY:

	Brian Hetrick, 02-Dec-86: Version 1.0
  000 - Original creation of module.

***********************************************************************)
{.PA}
(*
 *  INCLUDE FILES:
 *)

(*
 *  LABEL DECLARATIONS:
 *)

(*
 *  CONSTANT DECLARATIONS:
 *)

(*
 *  TYPE DECLARATIONS:
 *)

TYPE

    BaseNamePath = STRING [255];

(*
 *  OWN STORAGE:
 *)

(*
 *  TABLE OF CONTENTS:
 *)
{.PA}
FUNCTION BaseName
   (	PathSpec : BaseNamePath) : BaseNamePath;

(***********************************************************************

FUNCTIONAL DESCRIPTION:

    Extracts the last component of a path specification.  The components
    of a path specification are separated by colons  (:),  slashes  (/),
    and back slashes (\).

FORMAL PARAMETERS:

    Path.mt.r - The path specification from which the base name is to be
	extracted.

RETURN VALUE:

    The base name of the path specification.

IMPLICIT INPUTS:

    None.

IMPLICIT OUTPUTS:

    None.

SIDE EFFECTS:

    None.

***********************************************************************)

    VAR

	HoldIndex : INTEGER;
	ScanIndex : INTEGER;
	ThisChar  : CHAR;

    BEGIN

    HoldIndex := 1;

    FOR ScanIndex := 1 TO Length (PathSpec)
    DO
	BEGIN

	ThisChar := PathSpec [ScanIndex];

	IF (ThisChar = ':') OR
	   (ThisChar = '/') OR
	   (ThisChar = '\')
	THEN

	    HoldIndex := ScanIndex + 1

	END;

    BaseName := Copy (PathSpec, HoldIndex,
	Length (PathSpec) - HoldIndex + 1)

    END;
