C
C         VEHICLE MAINTENANCE PRGM        by Bruce W. Roeckel
C       *--------------------------*                         
C
$STORAGE:2
C
      COMMON/MONTHS/ IMON
      CHARACTER*4 IMON(13)
C
      COMMON /REVNO/ PGM,AUTHOR,YEAR,DATE,REV
      CHARACTER PGM*21,AUTHOR*21,YEAR*4,DATE*8,REV*2
C
      CHARACTER OPTION*25,TEST*8,SEL*1
      LOGICAL*2 CHECK
C
      IMON(1)='    '
      IMON(2)='Jan '
      IMON(3)='Feb '
      IMON(4)='Mar '
      IMON(5)='Apr '
      IMON(6)='May '
      IMON(7)='June'
      IMON(8)='July'
      IMON(9)='Aug '
      IMON(10)='Sept'
      IMON(11)='Oct '
      IMON(12)='Nov '
      IMON(13)='Dec '
C
C           DISPLAY ROCKSOFT HEADER
C
      PGM='Vehicle Records '
      AUTHOR='Bruce W. Roeckel'
      YEAR='1986'
      REV='11'
      CALL MHEAD(PGM,AUTHOR,YEAR,REV,DATE)
      CALL TOP(PGM,DATE)
C
C           READ DATABASE INTO CORE
C
      CALL RDMAST
C
C           CHECK FOR HELP FILE
C
      IHLP=0
      INQUIRE(FILE='VEHICLE.HLP',EXIST=CHECK)
      IF(CHECK .EQV. .TRUE.) THEN
         IHLP=1
         OPEN(UNIT=15,FILE='VEHICLE.HLP')
      ENDIF
C
C           NOW DISPLAY MAIN MENU
C
  100 CONTINUE
      OPTION='Main Menu'
      CALL HEADER(OPTION)
      CALL MOVEIT(1,5)
      WRITE(*,200) 
  200 FORMAT(//,
     A       /,15X,'1. Update Master File ....... Buy/Sell a Vehicle',
     B       /,15X,'                              Edit Vehicle Data ',
     C      //,15X,'2. Update Repair Log ........ Std. Maintenance  ',
     D       /,15X,'                              Special Repairs   ',
     E      //,15X,'3. Update Mileage Data ...... Around Town       ',
     F       /,15X,'                              Trip Mileage      ',
     G      //,15X,'4. Select Vehicle Reports ... Repair Summary    ',
     H       /,15X,'                              Mileage Summary   ',
     I       /,15X,'                              Graph"s           ')
C
C            ASK FOR SELECTION
C
  300 CONTINUE
      CALL MOVEIT(1,23)
      CALL BOLD
      WRITE(*,'(5X,A33,\)') 'Enter Choice (H=Help,Q=Quit) : '
      READ(*,'(A1)',ERR=300) SEL 
      CALL OFF
C
C            BRANCH BASED ON INPUT 
C
         IF (SEL.EQ.' ') THEN
            CALL BELL
            GOTO 300
         ELSEIF (SEL.EQ.'H' .OR. SEL.EQ.'h') THEN
            SEL=' '
            IUNIT=15
            CALL HELP(SEL,IUNIT)
            GOTO 100
         ELSEIF (SEL.EQ.'Q' .OR. SEL.EQ.'q') THEN
            IF(IHLP.EQ.1) CLOSE(15)
            CALL WRMAST
            CALL CLS
            STOP
         ELSEIF (SEL.EQ.'1') THEN
            CALL MASTER
         ELSEIF (SEL.EQ.'2') THEN
            CALL REPAIR
         ELSEIF (SEL.EQ.'3') THEN
            CALL MILES
         ELSEIF (SEL.EQ.'4') THEN
            CALL REPORT
         ELSE
            CALL BELL
            GOTO 300
         ENDIF
      GOTO 100
      END
C
C
C
      SUBROUTINE LISTEM(TYPE,SEL)
C
C
C          IF TYPE=0, LIST ALL VEHICLES
C          IF TYPE=1, LIST ONLY OWNED VEHICLES (NOT SOLD)
C
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      INTEGER TYPE,SEL,PICK(25)
C
      IV=6
      IH=1
      CALL UPTOP (IH,IV)
C
C            SET UP STARTING POINTERS
C
      IV=9
      IH=3
      IF (VNUM.LE.20) IH=15
      IF (VNUM.LE.10) IH=30
      ICNT=0
         CALL BOLD
         WRITE(*,'(//,25X,A17)') 'Vehicles on file:'
         CALL OFF
C
C            NOW LIST ALL VEHICLES
C
      DO 80 K=1,25
      PICK(K)=0
   80 CONTINUE
      DO 300 I=1,VNUM,10
         DO 200 J=I,I+9
         IF(J.GT.VNUM) GOTO 200
         IF((TYPE.EQ.1) .AND. (DATE(2,J).NE.' ')) GOTO 200
            IV=IV+1
            ICNT=ICNT+1
            PICK(J)=1
            CALL UPTOP(IH,IV)
            WRITE(*,100) J,NAME(J)
  100       FORMAT(1X,I2,'-',A20)
            IF(ICNT.GE.10) THEN
               IH=IH+25
               IV=9
               ICNT=0
            ENDIF
  200    CONTINUE
  300 CONTINUE
  350 CONTINUE
      IH=1
      IV=23
      CALL MOVEIT(IH,IV)
      CALL BOLD
      WRITE(*,400)
  400 FORMAT(8X,'Please Select Vehicle #  [ ]',\)
      CALL OFF
      INUM=3
      CALL CURLT(INUM)
         READ(*,'(I1)',ERR=500) SEL
         IF(SEL.EQ.0) RETURN
         IF((SEL.GT.VNUM) .OR. (PICK(SEL).NE.1)) GOTO 500
         RETURN
  500 CONTINUE
      CALL BELL
      GOTO 350
      END
C
C
C
      SUBROUTINE RDMAST
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      CHARACTER*25 OPTION
C
      OPTION='Loading Vehicle Desc.'
      CALL HEADER(OPTION)
      CALL KEYOFF
C
C            OPEN FILE FOR INPUT
C
      OPEN(20,FILE='VEHICLE.MAS')
C
C            READ ALL DATA FROM MASTER LOOKUP FILE
C
      I=0
  100 CONTINUE
      I=I+1
      IF(I.GT.25) THEN
         CALL BELL
         WRITE(*,'(A33)') 'Program Aborted Reading Master   '
         STOP
      ENDIF
      READ(20,200,END=300) NAME(I),IDNUM(I),DATE(1,I),COST(1,I),
     A    ODOM(1,I),DATE(2,I),COST(2,I),ODOM(2,I),RFILE(I),MFILE(I)
  200 FORMAT(A20,A20,A8,F9.2,F8.1,A8,F9.2,F8.1,A11,A11)
      GOTO 100
  300 CONTINUE
      VNUM=I-1
      CLOSE(20)
      CALL KEYON
      RETURN
      END
C
C
C
      SUBROUTINE WRMAST
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      CHARACTER*25 OPTION
C
      OPTION='Storing Vehicle Desc.'
      CALL HEADER(OPTION)
      CALL KEYOFF
C
C            OPEN FILE FOR OUTPUT
C
      OPEN(20,FILE='VEHICLE.MAS')
C
C            WRITE ALL DATA TO MASTER LOOKUP FILE
C
      DO 300 I=1,VNUM
      WRITE(20,200) NAME(I),IDNUM(I),DATE(1,I),COST(1,I),
     A    ODOM(1,I),DATE(2,I),COST(2,I),ODOM(2,I),RFILE(I),MFILE(I)
  200 FORMAT(A20,A20,A8,F9.2,F8.1,A8,F9.2,F8.1,A11,A11)
  300 CONTINUE
      ENDFILE 20
      CLOSE(20)
      CALL KEYON
      RETURN
      END
C
C
C
      SUBROUTINE RDREPS(SEL)
C
C         READ INDIVIDUAL REPAIR DATA
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      COMMON/REPAR1/ RDESC,RDATE
      CHARACTER RDESC(500)*25,RDATE(500)*8
C
      COMMON/REPAR2/ RCODE,RCOST,RODOM,RNUM
      INTEGER RCODE(500),RNUM
      REAL RCOST(500),RODOM(500)
C
      CHARACTER TDESC*25,TDATE*8,OPTION*25
      INTEGER TCODE,KEEP
      REAL TCOST,TODOM,MIN
C
      LOGICAL*2 CHECK
      INTEGER SEL  
C
C            LOAD IN THE REPAIR DATA
C
      RNUM=0
      IF(SEL.GT.VNUM) GOTO 500
      IF(RFILE(SEL).EQ.'           ') GOTO 500
C
C            MAKE SURE THE AUTO FILE EXISTS
C
      INQUIRE(FILE=RFILE(SEL),EXIST=CHECK)
      IF(CHECK.EQV..FALSE.) GOTO 500
C
C            OPEN FILE, GRAB ALL DATA
C
C
      OPTION='Loading Repair Data .....'
      CALL HEADER(OPTION)
      CALL KEYOFF
      OPEN(20,FILE=RFILE(SEL))
         K=0
  100    CONTINUE
         K=K+1
         IF(K.GT.500) THEN
            CALL BELL
            WRITE(*,'(A33)') 'Program Aborted Reading Repairs  '
            STOP
         ENDIF
         READ(20,200,END=300) RCODE(K),RDESC(K),RDATE(K),
     A                        RCOST(K),RODOM(K)
  200    FORMAT(I3,A25,A8,F9.2,F8.1)
         GOTO 100
  300    CONTINUE
         RNUM=K-1
         CLOSE(20)
         CALL KEYON
C
C         NOW SORT THE DATA
C
      K=0
  400 MIN=999999.9
      K=K+1
      IF(K.GE.RNUM) GOTO 500
      DO 450 I=K,RNUM
      IF(RODOM(I).LT.MIN) THEN
         MIN=RODOM(I)
         KEEP=I
      ENDIF
  450 CONTINUE
      TCODE=RCODE(K)
      TDESC=RDESC(K)
      TDATE=RDATE(K)
      TCOST=RCOST(K)
      TODOM=RODOM(K)
         RCODE(K)=RCODE(KEEP)
         RDESC(K)=RDESC(KEEP)
         RDATE(K)=RDATE(KEEP)
         RCOST(K)=RCOST(KEEP)
         RODOM(K)=RODOM(KEEP)
            RCODE(KEEP)=TCODE
            RDESC(KEEP)=TDESC
            RDATE(KEEP)=TDATE
            RCOST(KEEP)=TCOST
            RODOM(KEEP)=TODOM
      GOTO 400
  500 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE WRREPS(SEL)
C
C        WRITE INDIVIDUAL REPAIR DATA
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      COMMON/REPAR1/ RDESC,RDATE
      CHARACTER RDESC(500)*25,RDATE(500)*8
C
      COMMON/REPAR2/ RCODE,RCOST,RODOM,RNUM
      INTEGER RCODE(500),RNUM
      REAL RCOST(500),RODOM(500)
C
      CHARACTER*25 OPTION
      LOGICAL*2 CHECK
      INTEGER SEL
C
C            IF FILE DOES NOT EXIST, BUT DATA DOES, THEN CREATE
C
      IF(SEL.GT.VNUM) GOTO 500
      IF(RFILE(SEL).EQ.'           ') GOTO 500
C
C         FIGURE OUT IF FILE SHOULD BE CREATED
C
      INQUIRE(FILE=RFILE(SEL),EXIST=CHECK)
      IF((CHECK.EQV..FALSE.) .AND. (RNUM.GT.0)) THEN
         OPEN(20,FILE=RFILE(SEL),STATUS='NEW')
      ELSEIF(CHECK.EQV..FALSE.) THEN
         GOTO 500
      ELSEIF(CHECK.EQV..TRUE.) THEN
         OPEN(20,FILE=RFILE(SEL))
      ENDIF
C
C          WRITE ALL DATA TO FILE
C
      OPTION='Storing Repair Data .....'
      CALL HEADER(OPTION)
      CALL KEYOFF
         DO 300 K=1,RNUM
         WRITE(20,200) RCODE(K),RDESC(K),RDATE(K),
     A                 RCOST(K),RODOM(K)
  200    FORMAT(I3,A25,A8,F9.2,F8.1)
  300    CONTINUE
         ENDFILE 20
         CLOSE(20,STATUS='KEEP')
         CALL KEYON
  500 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE RDMILE(SEL)
C
C         READ MILEAGE DATA
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      COMMON/MILE1/ MDESC,MDATE
      CHARACTER MDESC(500)*25,MDATE(500)*8
C
      COMMON/MILE2/ MCODE,MCOST,MODOM,MNUM
      INTEGER MCODE(500),MNUM
      REAL MCOST(500),MODOM(500)
C
      CHARACTER TDESC*25,TDATE*8,OPTION*25
      INTEGER TCODE,KEEP
      REAL TCOST,TODOM,MIN
C
      INTEGER SEL
      LOGICAL*2 CHECK
C
C            LOAD IN THE MILEAGE DATA
C
      MNUM=0
      IF(SEL.GT.VNUM) GOTO 500
      IF(MFILE(SEL).EQ.'           ') GOTO 500
C
C            CHECK IF AUTO FILE EXISTS
C
      INQUIRE(FILE=MFILE(SEL),EXIST=CHECK)
      IF(CHECK.EQV..FALSE.) GOTO 500
C
C             EXISTS, SO READ IN DATA
C
      OPTION='Loading Mileage Data ....'
      CALL HEADER(OPTION)
      CALL KEYOFF
      OPEN(20,FILE=MFILE(SEL))
         K=0
  100    CONTINUE
         K=K+1
         IF(K.GT.500) THEN
            CALL BELL
            WRITE(*,'(A33)') 'Program Aborted Reading Mileage  '
            STOP
         ENDIF
         READ(20,200,END=300) MCODE(K),MDESC(K),MDATE(K),MCOST(K),
     A                        MODOM(K)
  200    FORMAT(I3,A25,A8,F9.2,F8.1)
         GOTO 100
  300    CONTINUE
         MNUM=K-1
         CLOSE(20)
         CALL KEYON
C
C         NOW SORT THE DATA
C
      K=0
  400 MIN=999999.9
      K=K+1
      IF(K.GE.MNUM) GOTO 500
      DO 450 I=K,MNUM
      IF(MODOM(I).LT.MIN) THEN
         MIN=MODOM(I)
         KEEP=I
      ENDIF
  450 CONTINUE
      TCODE=MCODE(K)
      TDESC=MDESC(K)
      TDATE=MDATE(K)
      TCOST=MCOST(K)
      TODOM=MODOM(K)
         MCODE(K)=MCODE(KEEP)
         MDESC(K)=MDESC(KEEP)
         MDATE(K)=MDATE(KEEP)
         MCOST(K)=MCOST(KEEP)
         MODOM(K)=MODOM(KEEP)
            MCODE(KEEP)=TCODE
            MDESC(KEEP)=TDESC
            MDATE(KEEP)=TDATE
            MCOST(KEEP)=TCOST
            MODOM(KEEP)=TODOM
      GOTO 400
  500 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE WRMILE(SEL)
C
C        WRITE MILEAGE DATA
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      COMMON/MILE1/ MDESC,MDATE
      CHARACTER MDESC(500)*25,MDATE(500)*8
C
      COMMON/MILE2/ MCODE,MCOST,MODOM,MNUM
      INTEGER MCODE(500),MNUM
      REAL MCOST(500),MODOM(500)
C
      CHARACTER*25 OPTION
      LOGICAL*2 CHECK
      INTEGER SEL
C
C            STORE THE MILEAGE DATA
C
      IF(SEL.GT.VNUM) GOTO 500
      IF(MFILE(SEL).EQ.'           ') GOTO 500
C
C            IF FILE DOES NOT EXIST, BUT DATA DOES, THEN CREATE
C
      INQUIRE(FILE=MFILE(SEL),EXIST=CHECK)
      IF((CHECK.EQV..FALSE.) .AND. (MNUM.GT.0)) THEN
         OPEN(20,FILE=MFILE(SEL),STATUS='NEW')
      ELSEIF(CHECK.EQV..FALSE.) THEN
         GOTO 500
      ELSEIF(CHECK.EQV..TRUE.) THEN
         OPEN(20,FILE=MFILE(SEL))
      ENDIF
C
C         WRITE ALL DATA TO FILE
C
      OPTION='Storing Mileage Data ....'
      CALL HEADER(OPTION)
      CALL KEYOFF
         DO 300 K=1,MNUM
         WRITE(20,200) MCODE(K),MDESC(K),MDATE(K),MCOST(K),
     A                 MODOM(K)
  200    FORMAT(I3,A25,A8,F9.2,F8.1)
  300    CONTINUE
         ENDFILE 20
         CLOSE(20,STATUS='KEEP')
         CALL KEYON
  500 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE DNAME(SEL)
C
C           PRINT NAME AT TOP OF SCREEN
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      INTEGER SEL
      CHARACTER TYPE*6,TEMP*80
C
      CALL UPTOP(1,7)
         WRITE(*,'(30X,A20)') ' Vehicle Selected : '
      TEMP=NAME(SEL)
      TYPE='CENTER'
      CALL JUSTIF(TYPE,TEMP,20)
      CALL BOLD
      CALL DHTOP
         WRITE(*,'(10X,A20)') TEMP
      CALL DHBOT
         WRITE(*,'(10X,A20)') TEMP
      CALL OFF
      RETURN
      END
