C
C         VEHICLE MAINTENANCE PRGM        by Bruce W. Roeckel
C       *--------------------------*                         
C           OPTION #4 - REPORTS   
C
C
$STORAGE:2
C
C
      SUBROUTINE REPORT 
C
C           GENERATE ALL VEHICLE REPORTS
C
      IMPLICIT INTEGER (A-Z)
C
      COMMON /REVNO/ PGM,AUTHOR,YEAR,DATE2,REV
      CHARACTER PGM*21,AUTHOR*21,YEAR*4,DATE2*8,REV*2
C
      COMMON/MONTHS/ IMON
      CHARACTER*4 IMON(13)
C
      COMMON/MAIN1/ NAME,IDNUM,DATE,RFILE,MFILE
      CHARACTER NAME(25)*20,IDNUM(25)*20,DATE(2,25)*8
      CHARACTER RFILE(25)*11,MFILE(25)*11
C
      COMMON/MAIN2/ COST,ODOM,VNUM
      INTEGER VNUM
      REAL COST(2,25),ODOM(2,25)
C
      COMMON/REPAR1/ RDESC,RDATE
      CHARACTER RDESC(500)*25,RDATE(500)*8
C
      COMMON/REPAR2/ RCODE,RCOST,RODOM,RNUM
      INTEGER RCODE(500),RNUM
      REAL RCOST(500),RODOM(500)
C
      COMMON/MILE1/ MDESC,MDATE
      CHARACTER MDESC(500)*25,MDATE(500)*8
C
      COMMON/MILE2/ MCODE,MCOST,MODOM,MNUM
      INTEGER MCODE(500),MNUM
      REAL MCOST(500),MODOM(500)
C
      REAL MSINCE,TMPG,TTLCST,MAX,AVE,LOIL,MPG,GNDAVE,GNDTTL
      REAL TPLOT(34),TTL1,TTL2,AVE1,AVE2
      CHARACTER OPTION*25,DESCR(9)*25
      CHARACTER SUBT1*8,SUBT2*8,TITLE*40
      CHARACTER ICODE*1,RAMDSK*80,KIND*6
C
      DESCR(1) =            'Oil Change w/ Filter     ' 
      DESCR(2) =            'Lubricated Front End     ' 
      DESCR(3) =            'Replaced Air Filter      ' 
      DESCR(4) =            'Replaced Distibutor Pnts ' 
      DESCR(5) =            'New Spark Plugs          ' 
      DESCR(6) =            'Front End Alignment      ' 
      DESCR(7) =            'Replaced Front Brakes    ' 
      DESCR(8) =            'Replaced Rear Brakes     ' 
      DESCR(9) =            'Rotated Tires            ' 
C
C           LIST ALL CARS, SELECT ONE TO WORK WITH
C
      TYPE=0
      OPTION='Vehicle Reports & Graphs '
      CALL HEADER(OPTION)
      CALL LISTEM(TYPE,SEL)
      IF(SEL.EQ.0) GOTO 9900
      CALL RDREPS(SEL)
      CALL RDMILE(SEL)
C
C           CALCULATE MILES SINCE OIL CHANGE
C
      DO 10 I=1,RNUM
      IF(RCODE(I).EQ.1) THEN
         LOIL = MODOM(MNUM) - RODOM(I) 
         GOTO 50
      ENDIF
   10 CONTINUE
C
C            DISPLAY MENU
C
   50 CONTINUE
      CALL HEADER(OPTION)
      CALL DNAME(SEL)
         WRITE(*,100) LOIL
  100    FORMAT(//,22X,F7.2,' Miles Since Last Oil Change',
     A         //,21X,'1. Maintenance & Repair Summary Report',
     B          /,21X,'2. City & Trip MPG Summary Report     ',
     C          /,21X,'3. Graph *Trip* Miles per Gallon Data ',
     D          /,21X,'4. Graph *City* Miles per Gallon Data ')
  125 CONTINUE
      CALL BOLD
      CALL MOVEIT(1,23)
      WRITE(*,'(5X,A37,\)') '     Enter Choice (H=Help, Q=Quit) : '
      READ(*,'(A1)',ERR=125) ICODE
      CALL OFF
C
C           BRANCH ON REQUEST
C
      IF(ICODE.EQ.'Q' .OR. ICODE.EQ.'q') THEN
C
         GOTO 9900
C
      ELSEIF(ICODE.EQ.'H' .OR. ICODE.EQ.'h') THEN
C
         ICODE='4'
         IUNIT=15
         CALL HELP(ICODE,IUNIT)
         GOTO 50
C
      ELSEIF(ICODE.EQ.'1' .OR. ICODE.EQ.'2' .OR.
     A       ICODE.EQ.'3' .OR. ICODE.EQ.'4') THEN
C
         WRITE(RAMDSK,'(A1)') ICODE
         READ(RAMDSK,'(I1)') KCODE
         CALL POINT(KCODE)
C
      ELSE
C
         CALL BELL
         GOTO 125
C
      ENDIF
C
C      =======================  START OF REPORTS  ==========================
C
      IF(KCODE.EQ.1 .AND. RNUM.GT.0) THEN
C
         UNIT=3
         OPEN(UNIT,FILE='OUTPUT.TMP',STATUS='NEW')
         CALL MOVEIT(1,23)
         CALL BOLD
         CALL BLINK
            WRITE(*,'(5X,A33,\)') 'Please Wait ... Generating Report'
         CALL OFF
         LINE=0
         PAGE=0
         TTLCST=0.0
         DO 300 I=1,RNUM
         IF(LINE.LE.0) THEN
            CALL PHEAD(PAGE,UNIT,PGM,DATE2,YEAR,REV)
            WRITE(UNIT,'(//,18X,2A20)') '   Repair Log for : ',NAME(SEL)
            WRITE(UNIT,150)
  150       FORMAT(/,5X,'                                   ',
     A                  '             Odometer  Miles Since',
     B             /,5X,'  Description of Repair     Dated  ',
     C                  '    Cost$     Reading    Repair  ',
     D             /,5X,'-------------------------  --------',
     E                  '  ---------  ---------  ---------')
            LINE=40
         ENDIF
         LINE=LINE-1
         IF(MNUM.GT.0) MSINCE=MODOM(MNUM)-RODOM(I)
            IF(RCODE(I).EQ.98) THEN
               WRITE(UNIT,200) RDESC(I),RDATE(I),RCOST(I),
     A                         RODOM(I),MSINCE
  200          FORMAT(5X,A25,2X,A8,2X,F9.2,2X,F9.1,2X,F9.1)
            ELSE
               WRITE(UNIT,250) DESCR(RCODE(I)),RDATE(I),RCOST(I),
     A                         RODOM(I),MSINCE
  250          FORMAT(3X,'* ',A25,2X,A8,2X,F9.2,2X,F9.1,2X,F9.1)
               IF(RDESC(I).NE.' ') THEN
                  WRITE(UNIT,275) RDESC(I)
  275             FORMAT(5X,'   Note: ',A25)
               ENDIF
            ENDIF
            TTLCST=TTLCST + RCOST(I)
  300    CONTINUE
         WRITE(UNIT,'(42X,A9,/,42X,A1,F8.2)') '=========','$',TTLCST
         WRITE(UNIT,325)
  325    FORMAT(///,5X,'NOTE: "*" Indicates Recurring ',
     A                 'Maintenance Items')
         CALL SHOWIT(UNIT)
         CLOSE(UNIT,STATUS='DELETE')
C
      ELSEIF(KCODE.EQ.2 .AND. MNUM.GT.0) THEN
C
         UNIT=3
         OPEN(UNIT,FILE='OUTPUT.TMP',STATUS='NEW')
         CALL MOVEIT(1,23)
         CALL BOLD
         CALL BLINK
            WRITE(*,'(5X,A33,\)') 'Please Wait ... Generating Report'
         CALL OFF
         LINE=0
         PAGE=0
         GNDTTL=0.0
         TTL1=0.0
         TTL2=0.0
         INUM1=0
         INUM2=0
         DO 500 I=2,MNUM
         IF(LINE.LE.0) THEN
            CALL PHEAD(PAGE,UNIT,PGM,DATE2,YEAR,REV)
            WRITE(UNIT,'(//,18X,2A20)') ' Mileage Data for : ',NAME(SEL)
            WRITE(UNIT,350)
  350       FORMAT(
     A            /,3X,'                     Odometer   City   Trip ',
     B            /,3X,'  Date     Gallons    Reading    MPG    MPG ',
     C                 '     Description of Trip   ',
     D            /,3X,'--------  ---------  ---------  -----  -----',
     E                 '  -------------------------')
            LINE=40
         ENDIF
         LINE=LINE-1
         MPG = (MODOM(I)-MODOM(I-1)) / MCOST(I)
         GNDTTL = GNDTTL + MPG
            IF(MCODE(I).EQ.1) THEN
               TTL1=TTL1 + MPG
               INUM1 = INUM1 + 1
               WRITE(UNIT,400) MDATE(I),MCOST(I),
     A                         MODOM(I),MPG,MDESC(I)
  400          FORMAT(3X,A8,2X,F9.2,2X,F9.1,9X,F5.1,2X,A25)
            ELSE
               TTL2=TTL2 + MPG
               INUM2 = INUM2 + 1
               WRITE(UNIT,450) MDATE(I),MCOST(I),
     A                         MODOM(I),MPG
  450          FORMAT(3X,A8,2X,F9.2,2X,F9.1,2X,F5.1)
            ENDIF
  500    CONTINUE
         IF(INUM1.GT.0) AVE1 = TTL1 / REAL(INUM1)
         IF(INUM2.GT.0) AVE2 = TTL2 / REAL(INUM2)
         IF((INUM1.GT.0) .OR. (INUM2.GT.0)) THEN
            GNDAVE = GNDTTL / (REAL(INUM1) + REAL(INUM2))
         ENDIF
         WRITE(UNIT,550) AVE2,AVE1,GNDAVE
  550    FORMAT(35X,'=====  =====',
     A        /, 9X,'Trip / City Average MPG : ',F5.1,2X,F5.1,
     B       //, 9X,'      TOTAL Average MPG : ',F5.1)
         CALL SHOWIT(UNIT)
         CLOSE(UNIT,STATUS='DELETE')
C
      ELSEIF(KCODE.EQ.3 .AND. MNUM.GT.0) THEN
C
         CALL MOVEIT(1,23)
         CALL BOLD
         CALL BLINK
            WRITE(*,'(5X,A17,\)') 'Please Wait .... '
         CALL OFF
C
C              MOVE DATA INTO TEMPORARY ARRAY
C
         IFRST=0
         ILST=0
         K=0
         DO 600 I=MNUM,2,-1
         IF(MCODE(I).EQ.1) THEN
            K=K+1
            IF(K.GT.34) THEN
               K=34
               GOTO 650
            ENDIF
            IF(ILST.EQ.0) ILST=I
            IFRST=I
            TPLOT(K)=(MODOM(I)-MODOM(I-1))/MCOST(I)
         ENDIF
  600    CONTINUE
  650    CONTINUE
C
C              NOW LOAD FILE WITH DATA
C
         IUNIT=2
         OPEN(IUNIT,FILE='PLOT.TMP',STATUS='NEW')
C
         DO 750 I=K,1,-1
         WRITE(IUNIT,700) TPLOT(I)
  700    FORMAT(12X,F12.2)
  750    CONTINUE
         ENDFILE IUNIT
C
C               DISPLAY THE GRAPH ...........  
C
         IF((IFRST.LE.0).AND.(ILST.LE.0)) GOTO 50
         TLEN=40
         TATTR=2
         SUBT1=' '
         SUBT2='Trip MPG'
         WRITE(TITLE,850) NAME(SEL),MDATE(IFRST),MDATE(ILST)
  850    FORMAT(A20,1X,A8,' - ',A8)
         CALL MOVEIT(1,5)
         CALL PLTSCR(IUNIT,TITLE,TLEN,TATTR,SUBT1,SUBT2)
         CLOSE(IUNIT,STATUS='DELETE')
         READ(*,'(A1)') ICODE
C
      ELSEIF(KCODE.EQ.4 .AND. MNUM.GT.0) THEN
C
         CALL MOVEIT(1,23)
         CALL BOLD
         WRITE(*,'(5X,A17,\)') 'Please Wait .... '
         CALL OFF
C
C              MOVE DATA INTO TEMPORARY ARRAY
C
         IFRST=0
         ILST=0
         K=0
         DO 1600 I=MNUM,2,-1
         IF(MCODE(I).EQ.2) THEN
            K=K+1
            IF(K.GT.34) THEN
               K=34
               GOTO 1650
            ENDIF
            IF(ILST.EQ.0) ILST=I
            IFRST=I
            TPLOT(K)=(MODOM(I)-MODOM(I-1))/MCOST(I)
         ENDIF
 1600    CONTINUE
 1650    CONTINUE
C
C              NOW LOAD FILE WITH DATA
C
         IUNIT=2
         OPEN(IUNIT,FILE='PLOT.TMP',STATUS='NEW')

         DO 1750 I=K,1,-1
         WRITE(IUNIT,700) TPLOT(I)
 1750    CONTINUE
         ENDFILE IUNIT
C
C               DISPLAY THE GRAPH ...........  
C
         IF((IFRST.LE.0).AND.(ILST.LE.0)) GOTO 50
         TLEN=40
         TATTR=2
         SUBT1=' '
         SUBT2='City MPG'
         WRITE(TITLE,850) NAME(SEL),MDATE(IFRST),MDATE(ILST)
         CALL MOVEIT(1,5)
         CALL PLTSCR(IUNIT,TITLE,TLEN,TATTR,SUBT1,SUBT2)
         CLOSE(IUNIT,STATUS='DELETE')
         READ(*,'(A1)') ICODE
C
      ENDIF
      GOTO 50
 9900 CONTINUE
      RETURN
      END
C
C
C
      SUBROUTINE POINT(KCODE)
C
      IH=17
      IV=13+KCODE
      CALL UPTOP(IH,IV)
      CALL BOLD
      CALL BLINK
         WRITE(*,'(A3)') '==>'
      CALL OFF
      RETURN
      END
