* Program   : CASHOUT.PRG
* Version   : V4.2
* Author(s) : Joe Tomas 
* Date      : 07/26/86
* Notice    : 
* Called by : SYSMGR1.PRG 
* Call(s)   :   
* Notes     : PERFORMS DAILY CASHOUT, PRINTS CASHOUT REPORT
*           : PERFORMS DATABASE BACKUP OF ORDERS & PRODUC FILES
CLEAR
CALL PAINT WITH "CASHOUT.IMG"
SET COLOR TO +*
@ 09,21 SAY 'BEFORE'
SET COLOR TO

STORE ' ' TO ANS
@ 20,00
?? VBELL1
SET COLOR TO +
@ 20,27 SAY 'CONTINUE (Y/N) ? ' GET ANS PICTURE "!"
SET COLOR TO
READ

IF ANS <> 'Y'
   CLEAR
   RETURN
ENDIF

DO BACKUP

CLEAR
SET COLOR TO I
@ 01,00
?? VWIDE+SPACE(40)
SET COLOR TO +I
@ 02,00
?? VWIDE+'      *** DAILY CASHOUT REPORT ***      '
SET COLOR TO I
@ 03,00
?? VWIDE+SPACE(40)
SET COLOR TO +
@ 08,00
?? VBELL1
@ 10,12 SAY "Make sure printer is turned on and blank paper loaded."
SET COLOR TO
@ 23,27 SAY 'PRESS ANY KEY TO CONTINUE'

DO WHILE INKEY() = 0
   SET COLOR TO +
   @ 23,33 SAY 'ANY KEY'
   SET COLOR TO
   @ 23,33 SAY 'ANY KEY'
ENDDO

@ 10,00 CLEAR
SET COLOR TO +*I
@ 10,18 SAY ' PRINTING CASHOUT REPORT...DO NOT INTERRUPT '

SET DEVICE TO PRINT
* SET PRINTER TO 132 COL. MODE
@ 0,1 SAY CHR(27)+'[4w'
@ 0,1 SAY CHR(27)+'[0t'
STORE 0 TO NXTLIN,COUNT
STORE 0 TO CATOT,CHTOT,POTOT,VITOT,MCTOT,AMTOT,PAIDTOT
STORE 0 TO CATAXTOT,CKTAXTOT,POTAXTOT,VITAXTOT,MCTAXTOT,AMTAXTOT,QTYTOT 
STORE 0 TO CASUB,CKSUB,POSUB,VISUB,MCSUB,AMSUB,PAIDSUB,TOTLIN

USE ORDERS
GOTO BOTTOM
STORE INVNUM TO ENDING
GOTO TOP
STORE INVNUM TO STARTING
@ 01,46 SAY '*** DAILY TRANSACTION/CASHOUT REPORT ***'
@ 02,60 SAY 'FOR '+ dtoc(date())

STORE NXTLIN+5 TO NXTLIN

@ NXTLIN,10 SAY "TRANSACTION DETAIL"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,10 SAY "------------------"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "TX #"
@ NXTLIN,021 SAY "CASH"
@ NXTLIN,035 SAY "CHECK"
@ NXTLIN,050 SAY "P.O."
@ NXTLIN,063 SAY "VISA"
@ NXTLIN,077 SAY "M/C"
@ NXTLIN,091 SAY "AMEX"
@ NXTLIN,105 SAY "TAX"
@ NXTLIN,116 SAY "NET INCOME"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "----"
@ NXTLIN,018 SAY "----------"
@ NXTLIN,032 SAY "----------"
@ NXTLIN,046 SAY "----------"
@ NXTLIN,060 SAY "----------"
@ NXTLIN,074 SAY "----------"
@ NXTLIN,088 SAY "----------"
@ NXTLIN,102 SAY "----------"
@ NXTLIN,116 SAY "----------"

DO WHILE .NOT. EOF()(ORDERS)
   STORE 0 TO CALIN,CKLIN,POLIN,VILIN,MCLIN,AMLIN
   STORE SUBAMT + TAXAMT TO NETLIN
   STORE SUBAMT TO PAIDLIN

   IF PAYTYP="CA"
      STORE PAIDLIN TO CALIN
      STORE TAXAMT + CATAXTOT TO CATAXTOT
   ENDIF
   IF PAYTYP="CK"
      STORE PAIDLIN TO CKLIN
      STORE TAXAMT + CKTAXTOT TO CKTAXTOT
   ENDIF
   IF PAYTYP="PO"
      STORE PAIDLIN TO POLIN
      STORE TAXAMT + POTAXTOT TO POTAXTOT
   ENDIF
   IF PAYTYP="VI"
      STORE PAIDLIN TO VILIN
      STORE TAXAMT + VITAXTOT TO VITAXTOT
   ENDIF
   IF PAYTYP="MC"
      STORE PAIDLIN TO MCLIN
      STORE TAXAMT + MCTAXTOT TO MCTAXTOT
   ENDIF
   IF PAYTYP="AM"
      STORE PAIDLIN TO AMLIN
      STORE TAXAMT + AMTAXTOT TO AMTAXTOT
   ENDIF

STORE QTYTOT+VAL(SUBSTR(ITEM01,4,3))+VAL(SUBSTR(ITEM02,4,3))+VAL(SUBSTR(ITEM03,4,3))+;
VAL(SUBSTR(ITEM04,4,3))+VAL(SUBSTR(ITEM05,4,3))+VAL(SUBSTR(ITEM06,4,3))+;
VAL(SUBSTR(ITEM07,4,3))+VAL(SUBSTR(ITEM08,4,3))+VAL(SUBSTR(ITEM09,4,3)) TO QTYTOT

   IF NXTLIN = 61
      @ 64,62 SAY "(CONT'D)"
      @ 65,00 SAY ' '
      STORE 2 TO NXTLIN
    
     @ NXTLIN,010 SAY "TRANSACTION DETAIL - CONT'D"
     STORE NXTLIN+1 TO NXTLIN
     @ NXTLIN,010 SAY "---------------------------"

     STORE NXTLIN+2 TO NXTLIN
     @ NXTLIN,010 SAY "TX #"
     @ NXTLIN,021 SAY "CASH"
     @ NXTLIN,035 SAY "CHECK"
     @ NXTLIN,050 SAY "P.O."
     @ NXTLIN,063 SAY "VISA"
     @ NXTLIN,077 SAY "M/C"
     @ NXTLIN,091 SAY "AMEX"
     @ NXTLIN,105 SAY "TAX"
     @ NXTLIN,116 SAY "NET INCOME"

     STORE NXTLIN+1 TO NXTLIN
     @ NXTLIN,010 SAY "----"
     @ NXTLIN,018 SAY "----------"
     @ NXTLIN,032 SAY "----------"
     @ NXTLIN,046 SAY "----------"
     @ NXTLIN,060 SAY "----------"
     @ NXTLIN,074 SAY "----------"
     @ NXTLIN,088 SAY "----------"
     @ NXTLIN,102 SAY "----------"
     @ NXTLIN,116 SAY "----------"
     STORE NXTLIN+1 TO NXTLIN
   ELSE
     STORE NXTLIN+1 TO NXTLIN
   ENDIF

   @ NXTLIN,010 SAY STR(INVNUM,4)
   @ NXTLIN,018 SAY CALIN PICTURE '999,999.99'
   @ NXTLIN,032 SAY CKLIN PICTURE '999,999.99'
   @ NXTLIN,046 SAY POLIN PICTURE '999,999.99'
   @ NXTLIN,060 SAY VILIN PICTURE '999,999.99'
   @ NXTLIN,074 SAY MCLIN PICTURE '999,999.99'
   @ NXTLIN,088 SAY AMLIN PICTURE '999,999.99'
   @ NXTLIN,102 SAY TAXAMT PICTURE '999,999.99'
   @ NXTLIN,116 SAY NETLIN PICTURE '999,999.99'

   STORE CASUB+CALIN TO CASUB
   STORE CKSUB+CKLIN TO CKSUB
   STORE POSUB+POLIN TO POSUB
   STORE VISUB+VILIN TO VISUB
   STORE MCSUB+MCLIN TO MCSUB
   STORE AMSUB+AMLIN TO AMSUB
   STORE TOTLIN+NETLIN TO TOTLIN

   STORE COUNT + 1 TO COUNT

   SKIP 1

ENDDO

STORE NXTLIN+1 TO NXTLIN

@ NXTLIN,018 SAY "----------"
@ NXTLIN,032 SAY "----------"
@ NXTLIN,046 SAY "----------"
@ NXTLIN,060 SAY "----------"
@ NXTLIN,074 SAY "----------"
@ NXTLIN,088 SAY "----------"
@ NXTLIN,102 SAY "----------"
@ NXTLIN,116 SAY "----------"

STORE CATAXTOT+CKTAXTOT+POTAXTOT+VITAXTOT+MCTAXTOT+AMTAXTOT TO TAXTOT
STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "TOTALS"
@ NXTLIN,018 SAY CASUB PICTURE '999,999.99'
@ NXTLIN,032 SAY CKSUB PICTURE '999,999.99'
@ NXTLIN,046 SAY POSUB PICTURE '999,999.99'
@ NXTLIN,060 SAY VISUB PICTURE '999,999.99'
@ NXTLIN,074 SAY MCSUB PICTURE '999,999.99'
@ NXTLIN,088 SAY AMSUB PICTURE '999,999.99'
@ NXTLIN,102 SAY TAXTOT PICTURE '999,999.99'
@ NXTLIN,116 SAY TOTLIN PICTURE '999,999.99'

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,002 SAY REPLICATE("=",130)

@ 65,00 SAY " "
STORE 002 TO NXTLIN

@ NXTLIN,046 SAY '*** DAILY TRANSACTION/CASHOUT REPORT ***'

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "CATEGORY SUMMARY"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "----------------"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,021 SAY "CASH"
@ NXTLIN,035 SAY "CHECK"
@ NXTLIN,050 SAY "P.O."
@ NXTLIN,063 SAY "VISA"
@ NXTLIN,077 SAY "M/C"
@ NXTLIN,091 SAY "AMEX"
@ NXTLIN,104 SAY "TOTALS"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,018 SAY "----------"
@ NXTLIN,032 SAY "----------"
@ NXTLIN,046 SAY "----------"
@ NXTLIN,060 SAY "----------"
@ NXTLIN,074 SAY "----------"
@ NXTLIN,088 SAY "----------"
@ NXTLIN,102 SAY "----------"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "INCOME"
@ NXTLIN,018 SAY CASUB PICTURE '999,999.99'
@ NXTLIN,032 SAY CKSUB PICTURE '999,999.99'
@ NXTLIN,046 SAY POSUB PICTURE '999,999.99'
@ NXTLIN,060 SAY VISUB PICTURE '999,999.99'
@ NXTLIN,074 SAY MCSUB PICTURE '999,999.99'
@ NXTLIN,088 SAY AMSUB PICTURE '999,999.99'
@ NXTLIN,102 SAY TOTLIN-TAXTOT PICTURE '999,999.99'

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "TAXES"
@ NXTLIN,018 SAY CATAXTOT PICTURE '999,999.99'
@ NXTLIN,032 SAY CKTAXTOT PICTURE '999,999.99'
@ NXTLIN,046 SAY POTAXTOT PICTURE '999,999.99'
@ NXTLIN,060 SAY VITAXTOT PICTURE '999,999.99'
@ NXTLIN,074 SAY MCTAXTOT PICTURE '999,999.99'
@ NXTLIN,088 SAY AMTAXTOT PICTURE '999,999.99'
@ NXTLIN,102 SAY TAXTOT PICTURE '999,999.99'

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,018 SAY "=========="
@ NXTLIN,032 SAY "=========="
@ NXTLIN,046 SAY "=========="
@ NXTLIN,060 SAY "=========="
@ NXTLIN,074 SAY "=========="
@ NXTLIN,088 SAY "=========="
@ NXTLIN,102 SAY "=========="

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "TOTALS"
@ NXTLIN,018 SAY CATAXTOT+CASUB PICTURE '999,999.99'
@ NXTLIN,032 SAY CKTAXTOT+CKSUB PICTURE '999,999.99'
@ NXTLIN,046 SAY POTAXTOT+POSUB PICTURE '999,999.99'
@ NXTLIN,060 SAY VITAXTOT+VISUB PICTURE '999,999.99'
@ NXTLIN,074 SAY MCTAXTOT+MCSUB PICTURE '999,999.99'
@ NXTLIN,088 SAY AMTAXTOT+AMSUB PICTURE '999,999.99'
@ NXTLIN,102 SAY TOTLIN PICTURE '999,999.99'

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,002 SAY REPLICATE("=",130)

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "DAILY STATISTICS"
STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "----------------"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "TOTAL TRANSACTIONS  "+STR(COUNT,10)+;
" ("+STR(STARTING,4)+" thru "+STR(ENDING,4)+")"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "TOTAL ITEMS SOLD    "+STR(QTYTOT,10)

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "AVERAGE SALE/TX     "
@ NXTLIN,030 SAY (TOTLIN-TAXTOT)/COUNT PICTURE '999,999.99'

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "AVERAGE ITEM PRICE  "
@ NXTLIN,030 SAY (TOTLIN-TAXTOT)/QTYTOT PICTURE '999,999.99'

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "CASH  % OF TOTAL    "+;
STR((CASUB/(TOTLIN-TAXTOT)*100),10,2)+" %"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "CHECK % OF TOTAL    "+;
STR((CKSUB/(TOTLIN-TAXTOT)*100),10,2)+" %"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "P.O.  % OF TOTAL    "+;
STR((POSUB/(TOTLIN-TAXTOT)*100),10,2)+" %"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "VISA  % OF TOTAL    "+;
STR((VISUB/(TOTLIN-TAXTOT)*100),10,2)+" %"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "M/C   % OF TOTAL    "+;
STR((MCSUB/(TOTLIN-TAXTOT)*100),10,2)+" %"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "AMEX  % OF TOTAL    "+;
STR((AMSUB/(TOTLIN-TAXTOT)*100),10,2)+" %"

STORE NXTLIN+2 TO NXTLIN

@ NXTLIN,010 SAY "END OF CASHOUT REPORT.......... "+dtoc(date())

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,002 SAY REPLICATE("=",130)

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "CASH DRAWER RECONCILIATION"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "--------------------------"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "PAYMENT TYPE"
@ NXTLIN,030 SAY "SYSTEM TOTALS"
@ NXTLIN,050 SAY "ACTUAL TOTALS"
@ NXTLIN,080 SAY "OVER / (SHORT)"

STORE NXTLIN+1 TO NXTLIN
@ NXTLIN,010 SAY "------------"
@ NXTLIN,030 SAY "-------------"
@ NXTLIN,050 SAY "-------------"
@ NXTLIN,080 SAY "--------------"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "CASH..........."
@ NXTLIN,030 SAY CASUB+CATAXTOT PICTURE '999,999.99'
@ NXTLIN,047 SAY "____________________"
@ NXTLIN,077 SAY "____________________"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "CHECK.........."
@ NXTLIN,030 SAY CKSUB+CKTAXTOT PICTURE '999,999.99'
@ NXTLIN,047 SAY "____________________"
@ NXTLIN,077 SAY "____________________"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "P.O............"
@ NXTLIN,030 SAY POSUB+POTAXTOT PICTURE '999,999.99'
@ NXTLIN,047 SAY "____________________"
@ NXTLIN,077 SAY "____________________"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "VISA..........."
@ NXTLIN,030 SAY VISUB+VITAXTOT PICTURE '999,999.99'
@ NXTLIN,047 SAY "____________________"
@ NXTLIN,077 SAY "____________________"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "M/C............"
@ NXTLIN,030 SAY MCSUB+MCTAXTOT PICTURE '999,999.99'
@ NXTLIN,047 SAY "____________________"
@ NXTLIN,077 SAY "____________________"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "AMEX..........."
@ NXTLIN,030 SAY AMSUB+AMTAXTOT PICTURE '999,999.99'
@ NXTLIN,047 SAY "____________________"
@ NXTLIN,077 SAY "____________________"

STORE NXTLIN+2 TO NXTLIN
@ NXTLIN,010 SAY "BEGINNING DRAWER BALANCE............"
@ NXTLIN,047 SAY "____________________"

@ NXTLIN+4,010 SAY "DONE BY: ______________________________________________"
@ 65,00 SAY " "
* SET PRINTER TO 80 COL. MODE
@ 01,01 SAY CHR(27)+'[1w'

SET DEVICE TO SCREEN
USE
SET COLOR TO
@ 06,01 CLEAR

@ 08,05 SAY "WARNING:  The next process will DELETE today's ORDERS file"
@ 09,05 SAY "          to prepare for tomorrow's new orders."

@ 11,05 SAY "          Please be sure that everything is OK.  If all is"
@ 12,05 SAY '          OK, respond with DELETE at the prompt.  Otherwise,'
@ 13,05 SAY '          respond with N, return to the Main Menu and repeat'
@ 14,05 SAY "          the Cashout process."
SET COLOR TO +*
@ 08,05 SAY 'WARNING'
@ 08,37 SAY 'DELETE'
SET COLOR TO +
@ 12,32 SAY 'DELETE'
@ 13,28 SAY 'N'
SET COLOR TO
STORE '      ' TO ANS

DO WHILE .T.

   @ 22,10
   ?? 'CONTINUE?  TYPE '+VBOLD+VBLINK+'<DELETE>'+VNORM+' OR'+VBOLD+VBLINK+;
      ' <N> '+VNORM
   @ 22,45  GET ANS
   READ
   CLEAR GETS
   IF UPPER(ANS) <> 'DELETE'
      STORE 'ORDER FILE NOT DELETED' TO DEL
      SAVE TO NODELETE.MEM ALL LIKE DEL
      CLEAR
      RETURN
   ENDIF

   IF UPPER(ANS) = 'DELETE'
      USE ORDERS
      ZAP
      USE

      IF FILE('NODELETE.MEM')
         DELETE FILE NODELETE.MEM
      ENDIF

      @ 04,00 CLEAR
      SET COLOR TO +
      @ 10,26 SAY ' ORDERS DATA FILE DELETED '
      SET COLOR TO
      **** SET DAILY TOTALS TO ZERO FOR NEXT DAY PROCESSING
    
      STORE 00000.00 TO TOTAL
      SAVE TO CASHTAKE ALL LIKE TOTAL

      ?? VBELL1
      @ 23,27 SAY 'PRESS ANY KEY TO CONTINUE'

      DO WHILE INKEY() = 0
         SET COLOR TO +
         @ 23,33 SAY 'ANY KEY'
         SET COLOR TO
         @ 23,33 SAY 'ANY KEY'
      ENDDO
      CLEAR
      RETURN
   ENDIF
ENDDO
