;
; *** Listing 11-22 ***
;
; Compares two word-sized arrays of equal length to see
; whether they differ, and if so where, using LODSW and
; SCASW.
;
	jmp	Skip
;
WordArray1	dw	100 dup (1), 0, 99 dup (2)
ARRAY_LENGTH_IN_WORDS	equ	(($-WordArray1)/2)
WordArray2	dw	100 dup (1), 100 dup (2)
;
; Returns pointers to the first locations at which two
; word-sized arrays of equal length differ, or zero if
; they're identical.
;
; Input:
;	CX = length of the arrays (they must be of equal
;		length)
;	DS:SI = the first array to compare
;	ES:DI = the second array to compare
;
; Output:
;	DS:SI = pointer to the first differing location in
;		the first array if there is a difference,
;		or SI=0 if the arrays are identical
;	ES:DI = pointer to the first differing location in
;		the second array if there is a difference,
;		or DI=0 if the arrays are identical
;
; Registers altered: AX, SI, DI
;
; Direction flag cleared
;
; Note: Does not handle arrays that are longer than 32K
;	words or cross segment boundaries.
;
FindFirstDifference:
	cld
	jcxz	FindFirstDifferenceSame
				;if there's nothing to
				; check, we'll consider the
				; arrays to be the same.
				; (If we let LOOP
				; execute with CX=0, we'll
				; get 64 K repetitions)
FindFirstDifferenceLoop:
	lodsw
	scasw			;compare the next two words
	jnz	FindFirstDifferenceFound
				;the arrays differ
	loop	FindFirstDifferenceLoop
				;the arrays are the
				; same so far
FindFirstDifferenceSame:
	sub	si,si		;indicate that the strings
	mov	di,si		; are identical
	ret
FindFirstDifferenceFound:
	dec	si		;the arrays differ, so
	dec	si		; point back to first
	dec	di		; difference in both arrays
	dec	di
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset WordArray1	;point to the two
	mov	di,ds			; arrays to be
	mov	es,di			; compared
	mov	di,offset WordArray2	
	mov	cx,ARRAY_LENGTH_IN_WORDS
					;# of words to check
	call	FindFirstDifference	;see if they differ
	call	ZTimerOff
