;
; *** Listing 11-19 ***
;
; Tests whether several characters are in the set
; {A,Z,3,!} by using REPNZ SCASB.
;
	jmp	Skip
;
; List of characters in the set.
;
TestSet	db	"AZ3!"
TEST_SET_LENGTH	equ	($-TestSet)
;
; Determines whether a given character is in TestSet.
;
; Input:
;	AL = character to check for inclusion in TestSet
;
; Output:
;	Z if character is in TestSet, NZ otherwise
;
; Registers altered: DI, ES
;
; Direction flag cleared
;
CheckTestSetInclusion:
	push	ds
	pop	es
	mov	di,offset TestSet
			;point ES:DI to the set in which to
			; check inclusion
	mov	cx,TEST_SET_LENGTH
			;# of characters in TestSet
	cld
	repnz	scasb	;search the set for this character
	ret		;the success status is already in
			; the Zero flag
;
Skip:
	call	ZTimerOn
	mov	al,'A'
	call	CheckTestSetInclusion	;check 'A'
	mov	al,'Z'
	call	CheckTestSetInclusion	;check 'Z'
	mov	al,'3'
	call	CheckTestSetInclusion	;check '3'
	mov	al,'!'
	call	CheckTestSetInclusion	;check '!'
	mov	al,' '
	call	CheckTestSetInclusion	;check space, so
					; we get a failed
					; search
	call	ZTimerOff
