#!/usr/bin/perl --

use base;
use CGI;
require "hostname.pl";

# $ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/gnu/bin";

# ----------------------------------------------------------------------
# Configuration variables.

$hostname = hostname;
if ($hostname eq "twilight") {
    $datdir = "F:/adv/adventure";
} else {
    $datdir = "/home/sites/www.if-legends.org/users/adventure/web";
}

$debug = 0;

# End of configuration variables.
#----------------------------------------------------------------------

#$game_file = "$datdir/search.dat";
$game_file = "search.dat";

open(GAMES, "$game_file") || die("Can't open $game_file!");

$req = new CGI;

$r_mode = $req->param('mode');
$r_string = $req->param('string');
$r_game = $req->param('game');
$r_year = $req->param('year');
$r_company = $req->param('company');
$r_type = $req->param('type');
$r_author = $req->param('author');

print $req->header;

print "<html><head><title>Adventureland: Search Results</title></head>\n";
print "<body bgcolor=#000000 text=#FFFFFF link=#FFFF00 vlink=l#FF990>\n";
print "<h1>Adventureland: Search Results</h1>\n";
print "<p><hr>\n";

$hits = 0;

if ($r_mode eq "game") {
    $r_game = $r_string;
} elsif ($r_mode eq "year") {
    $r_year = $r_string;
} elsif ($r_mode eq "company") {
    $r_company = $r_string;
} elsif ($r_mode eq "type") {
    $r_type = $r_string;
} elsif ($r_mode eq "author") {
    $r_author = $r_string;
}

print "<p>Search was: $r_mode = $r_string\n" if ($r_mode);

while ($line = <GAMES>) {
    ($company, $s_company, $game, $s_game, $year, $type, $author) = 
	split(/\t/, $line);
    $year =~ s/\s+$//;

    if ($r_game) {
	next unless $game =~ m/$r_game/i;
    } elsif ($r_year) {
	next unless $year =~ m/$r_year/;
    } elsif ($r_company) {
	next unless $company =~ m/$r_company/i;
    } elsif ($r_type) {
	next unless $type =~ m/\b$r_type\b/i;
    } elsif ($r_author) {
	next unless $author =~ m/$r_author/i;
    }

    print "<p><a href=\"$s_company\">$company</a>: <a href=\"$s_company#$s_game\">$game</a>" . ($year ? " ($year)" : "") . "\n";
    $hits++;
}

print "<p>$hits game" . ($hits == 1 ? "" : "s") . " match your query.\n";

print "<p><hr>\n" if ($debug);
print "<br>game = $r_game\n" if ($debug);
print "<br>year = $r_year\n" if ($debug);
print "<br>company = $r_company\n" if ($debug);
print "<br>type = $r_type\n" if ($debug);
print "<br>Looking in $datdir with host '$hostname'.\n" if ($debug);

print "<p><hr>\n";
print "<p><a href=\"index.html\">Adventureland</a> was created by Hans Persson and is now maintained by Stefan Meier (<tt><a href=\"mailto:adventureland\@if-legends.org\">adventureland\@if-legends.org</a></tt>).\n";
print "<p>If you find any errors or have information that is missing, please <a href=\"helpform.html\">let me know</a>.\n";
print "</td></tr></table></body></html>\n";

print $req->end_html;