/*
 * decdates.cpp
 *
 * Routines to handle dates in format DD-MMM-YY
 *
 * John Dudeck   SIM International   25-Aug-92
 */

#include <dos.h>
#include <stdio.h>
#include "decdates.h"

// Month string table for generating DD-MMM-YY format.
static char * mon[] = {"Duh","Jan","Feb","Mar","Apr","May","Jun",
                             "Jul","Aug","Sep","Oct","Nov","Dec"};


// rtdatetodec()
// First argument is the address of a 10-byte destination buffer
//  which must be provided by the calling program.
// Second argument is RT11 date to be converted which is
//  stored as a string in DD-MMM-YY format at destination.
// Resulting string is always 10 bytes long (9 chars plus null).

// RT-11 date format (as used in directory entries, etc):
// bits 0-4   year since 1972
//      5-9   day of month
//    10-14   month
//       15   reserved

void rtdatetodec(char * dest, short int rtdate) {
   int rtyear = (rtdate & 0x1f) + 1972;
   int rtday = (rtdate >> 5) & 0x1f;
   int rtmonth = (rtdate >> 10) & 0x1f;

   sprintf(dest, "%02d-%3s-%02d", rtday, mon[rtmonth], rtyear%100);
   dest[9] = '\0';
}


// getdecdate()
// gets current system date and stores it as a string in DD-MMM-YY
// format at destination.  Resulting string is always 10 bytes long.

void getdecdate(char * dest) {

   // Format today's date as DD-MMM-YY.
   struct date dats;
   getdate(&dats);
   sprintf(dest, "%02d-%3s-%02d", dats.da_day, mon[dats.da_mon], dats.da_year%100);
   dest[9] = '\0';
}
