/*
 * rtfile.h
 *
 * RT-11 file class.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#ifndef _RTFILE
#define _RTFILE

#include "file_t.h"
// max # chars in name part
#define RNLEN 6
// max # chars in extension part
#define RELEN 3

class RTfile : public file_t {
public:
   char drive[2];     // These are terminated by \0
   char name[RNLEN+1];
   char ext[RELEN+1];
   
   RTfile(char *);
   // effects: Constructs a normalized RT-11 filename entry.
   //          May have wildcards.

   RTfile();
   // effects: Constructs an empty RT-11 filename entry.
   
   boolean testRTspec(RTfile &);
   // effects: Compares the argument against the object's name and
   //          extension fields.  The object's fields may have wildcards.
   // Returns: 'true' if the arguments fit the object's specification
   //          according to wildcard matching.
   // Note: Wildcard matching follows MS-DOS rules and not RT-11!

   void print();
   // effects: Prints file name to cout.
};
#endif
