/*
 * rtdefs.h
 *
 * internal data structures for RT-11 diskettes.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#ifndef _RTDEFS
#define _RTDEFS

#include "rad50.h"

#define HOMEBLOK_NO 1
#define FIRST_DIRBLOK 6
#define HOMEBLKSIZ 1
#define DIRSEGSIZ 2  // 2 blocks per directory segment
#define DATBUFSIZ 512 // Data block size in bytes
#define DEFDRIVE 'D'

struct homeblok {  // The homeblock is 512 bytes long
   char filler_1[472];
   char rtvol_id[12];
   char rtvol_owner[12];
   char rtvol_sys_id[12];
   char filler_2[4];
};

struct dirblok {  // A directory block (segment) is 1024 bytes long
   // There are 10 bytes of header info in each block
   short int tota; // total no of segments in directory
   short int next; // seg no of next dir seg, 0 if none
   short int high; // no of highest seg currently in use (only in 1st seg)
   short int extr; // no of extra bytes per dir entry
   short int strt; // starting block no of data for this segment
   struct {  // Each entry is 14 bytes long
      short int status;  // file status
      unsigned short int name[3]; // file name; 3 words of Rad-50
      short int leng;    // size in blocks of file (or free area)
      char chan;         // channel no of tentative entry
      char jnum;         // job number of tentative entry
      short int date;    // creation date
      // extra words, if any.
   } dir_entry[72];
   char filler_3[6];
};

// Status word definitions (octal).
#define TENT      0400  // Tentative entry
#define EMPTY    01000  // Empty entry
#define PERM     02000  // Permanent entry
#define ENDBLK   04000  // End of segment
#define PROT   0100000  // Protected entry (only if permanent)

typedef int boolean;
enum {false, true};
#endif
