/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <vport50/mach.h>
#include <vport50/addr.h>
#include <vport50/setjmp.h>
#include <vport50/status.h>
#include <common/command.h>
#include <common/stdio.h>
#include <common/string.h>
#include <common/break.h>

struct command c_reg[] = {
        "ax",    REG_AX,
        "bx",    REG_BX,
        "cx",    REG_CX,
        "dx",    REG_DX,
        "si",    REG_SI,
        "di",    REG_DI,
        "bp",    REG_BP,
        "sp",    REG_SP,
        "ip",    REG_IP,
        "ds",    REG_DS,
        "es",    REG_ES,
        "cs",    REG_CS,
        "ss",    REG_SS,
        "flags", REG_PS,
        0, 0
};

struct flagtab flagtab[] = {
        0x0001, 'C',
        0x0004, 'P',
        0x0010, 'A',
        0x0040, 'Z',
        0x0080, 'N',
        0x0100, 'T',
        0x0200, 'I',
        0x0400, 'D',
        0x0800, 'V',
        0, 0,
};

/* showreg, clrreg, initreg - Register anzeigen, loeschen und initialisieren */
void showreg()
{
        register flags;
        DS_VAR(ds);

        STACK(ds);
        flags = trace ? status.flags : status.flags&0xfeff;

        printf("\
ax = %r, bx = %r, cx = %r, dx = %r\n\
si = %r, di = %r, bp = %r, sp = %r\n\
cs = %r, ds = %r, es = %r, ss = %r\n\
ip = %r, Flags = %r, %F\n\
", status.ax, status.bx, status.cx, status.dx,
               status.si, status.di, status.bp, status.sp,
               status.cs, status.ds, status.es, status.ss,
               status.ip, flags, flags);

        RESTORE(ds);
        return;
}

void clrreg()
{
        DS_VAR(ds);
        STACK(ds);
        status.ax = status.bx = status.cx = status.dx = status.si = status.di =
                status.bp = status.sp = status.cs = status.ds = status.es =
                status.ss = status.ip = status.flags = 0;
        trace = istrace();
        RESTORE(ds);
}

void initreg(addr)
        addr_t *addr;
{
        DS_VAR(ds);

        STACK(ds);
        status.cs = addr->seg;
        status.ip = addr->ofs;
        status.ss = jmpbuf.ss;
        status.sp = STACKPTR;
        RESTORE(ds);
}
