/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __ADDR_H
#define __ADDR_H

#include <vport50/mach.h>

/* Adressmanipulation */
extern void add_addr();
extern void sub_addr();
extern void inc_addr();
extern void dec_addr();
extern int  cmp_addr();
extern void cpy_addr();
extern void set_addr();
extern void clr_addr();

/* der 8086 hat kein Problem mit ungeraden Adressen */
#define odd_addr_err(a)
#define odd_addr_inc(a)

/* direkter Speicherzugriff */
extern void writeb();
extern void writew();
extern unsigned int readb();
extern unsigned int readw();
#define read_break(addr) readb((addr))
#define write_break(addr, val) writeb((addr), (val))
#define read_mem(addr) readb((addr))
#define write_mem(addr, val) writeb((addr), (val))

/* IO-Zugriffe, siehe helper.s */
extern void out();
extern char in();

/* der 8086 hat kein Problem mit ungeraden I/O-Adressen */
#define odd_port(a)

/* Adress-Ein/Ausgabe */
extern char* scan_addr();
extern void print_addr();

#endif /* __ADDR_H */
