/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <pdp11/setjmp.h>
#include <pdp11/status.h>
#include <pdp11/mach.h>
#include <pdp11/addr.h>
#include <common/stdio.h>
#include <common/string.h>
#include <common/intel.h>

void intel()
{
        char buf[80];
        char *ptr;
        unsigned int cnt, typ, val, sum;
        addr_t addr;
     
loop:
        sum=0;
        printf("> ");
        ptr=gets(buf, 79);
        if(buf[0] != ':')
                goto error;

        cnt  = hex(buf[1]) << 4;
        cnt += hex(buf[2]);
        sum += cnt;

        addr  = hex(buf[3]) <<12;
        addr += hex(buf[4]) << 8;
        addr += hex(buf[5]) << 4;
        addr += hex(buf[6]);
        sum += (addr&0xff00)>>8;
        sum += (addr&0x00ff);
     
        typ  = hex(buf[7]) << 4;
        typ += hex(buf[8]);
        sum += typ;

        ptr = buf + 9;
     
        switch(typ) {
        case IH_DATA: /* data record */
                while(cnt--) {
                        val  = hex(*ptr++) << 4;
                        val += hex(*ptr++);
                        sum += val;
                        writeb(&addr, val);
                        inc_addr(&addr);
                }
                break;

        case IH_END: /* end record */
                break;

        default:
                printf("%c%cillegal record type\n", 7, 7);
                longjmp();
                break;
        }
        val  = hex(*ptr++) << 4;
        val += hex(*ptr++);
        sum += val;
        if(sum&0x00ff) {
                printf("%c%cchecksum error\n", 7, 7);
                longjmp();
        }
        if(typ == 0x01)
                return;
        else goto loop;
      
error:
        printf("%c%cnot Intel-Hex format\n", 7, 7);
        longjmp();
}
