/* VPort-50 Monitor
   Copyright (c) 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

.section .text
                
/* unsigned int __umodsi3(unsigned int dividend, unsigned int divisor)
   Wrapper fr __udivsi3, der den Rest in R0 zurckgibt
*/       
.globl  __umodsi3
__umodsi3:
        stmfd   sp!, {lr}               /* LR retten */
        bl      __udivsi3               /* dividieren */
        mov     r0, r1                  /* Rest zurckgeben */
        ldmfd   sp!, {pc}

/* Vorzeichenlose Ganzzahldivision fr C
   unsigned int __udivsi3 (unsgined int dividend, unsigned int divisor)
   Rckgabe: R0 - Quotient, R1 - Rest
*/      
.globl  __udivsi3
__udivsi3:
        eor     r0, r1, r0              /* R0 und R1 vertauschen */
        eor     r1, r0, r1
        eor     r0, r1, r0
                          
        cmp     r0, #1
        bcc     .divby0                 /* Sonderfall: Division durch 0 */
        beq     .divby1                 /* Sonderfall: Division durch 1 */
        mov     r12, #0                 /* R12 initialisieren, enthlt Informationen ber Dividenden */
        movs    r1, r1                  /* Dividend testen */
        bpl     .posx                   /* 0 < Dividend < 2^31, keine Sonderbehandlung ntig */
        orr     r12, r12, #0x20000000   /* Bit 31 des Dividenden speichern */
        movs    r1, r1, lsr #1          /* Dividend /= 2 */
        orrcs   r12, r12, #0x10000000   /* Bit 0 des Dividenden speichern */

.posx:
        mov     r2, #1                  /* R2 = Konstant 1 fr Shifts */
        mov     r3, #0                  /* R3 = Quotient, initialisieren */

        .irp    shift, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30
                cmp     r1, r0, lsl #\shift     /* Dividend - Divisor * 2^x, 0 <= x <= 30 */
                bcc     .b\shift                /* Sprung beim ersten x fr das gilt Dividend < Divisor * 2^x */
        .endr
                
        .irp    shift, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0
                cmp     r1, r0, lsl #\shift     /* Dividend - Divisor * 2^y, 0 <= y < x */
                subhs   r1, r1, r0, lsl #\shift /* wenn Dividend >= Divisor * 2^y, Dividend -= Divisor * 2^y (Rest) */
                addhs   r3, r3, r2, lsl #\shift /* wenn Dividend >= Divisor * 2^y, Quotient += 2^y */
        .b\shift:
        .endr

        tst     r12, #0x20000000
        bne     .negx                   /* Dividend negativ, Ergebnis korrigieren */
        mov     r0, r3                  /* Quotienten zurckgeben */
        mov     pc, lr

.negx:
        tst     r12, #0x10000000        /* Bit 0 in Z-Flag */
        mov     r1, r1, lsl #1          /* Dividend (Rest) *= 2 */
        orrne   r1, r1, #1              /* Bit 0 wiederherstellen */
        mov     r3, r3, lsl #1          /* Quotient *= 2 */
        cmp     r1, r0                  /* Dividend - Divisor */
        subhs   r1, r1, r0              /* wenn Dividend >= Divisor, Dividend -= Divisor (Rest) */
        addhs   r3, r3, r2              /* wenn Dividend >= Divisor, Quotient++ */
        mov     r0, r3                  /* Quotienten zurckgeben */
        mov     pc, lr

/* Division durch 1, Dividend wird als Quotient zurckgegeben, Rest 0 */
.divby1:
        mov     r0, r1
        mov     r1, #0
        mov     pc, lr
        
/* Division durch 0, Dividend wird unendlich (beinahe, zumindest) */
.divby0:
        mvn     r0, #0
        mov     pc, lr
