/* VPort-50 Monitor
   Copyright (c) 2005, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __UART_H
#define __UART_H

/* UART-Register, einige doppelt belegt */
struct uart {
     volatile unsigned long rbr;
#define thr rbr
#define dll rbr
     volatile unsigned long ier;
#define dlm ier
     volatile unsigned long iir;
#define fcr iir
     volatile unsigned long lcr;
     volatile unsigned long mcr;
     volatile unsigned long lsr;
     volatile unsigned long msr;
     volatile unsigned long scr;
};

#define BAUD(x)      (15000000/(x*16))
#define LO(x)        (x&0xff)
#define HI(x)        ((x>>8)&0xff)

#define IER_RXINT    0x01
#define IER_TXINT    0x02
#define IER_STINT    0x04
#define IER_MSTINT   0x08
#define IER_MASK(x)  (x&0xf)

#define IIR_PEND     0x01
#define IIR_FIFO     0x80
#define IIR_IDENT(x) (x&0xe)
#define IIR_ST       (0x3<<1)
#define IIR_RX       (0x2<<1)
#define IIR_CT       (0x6<<1)
#define IIR_TX       (0x1<<1)
#define IIR_MODEM    0x0

#define FCR_FENB     0x01
#define FCR_RXRST    0x02
#define FCR_TXRST    0x04
#define FCR_TRIG(x)  ((x&0x3)<<6)
#define FCR_MASK(x)  (x&0xc7)

#define LCR_WLEN(x)  ((x-5)&0x03)
#define LCR_STOP(x)  (((x-1)&0x01)<<2)
#define LCR_PAREN    0x08
#define LCR_PODD     0x00
#define LCR_PEVEN    0x10
#define LCR_PMARK    0x20
#define LCR_PSPACE   0x30
#define LCR_BREAK    0x40
#define LCR_DLAB     0x80

#define LSR_RXRDY    0x01
#define LSR_OE       0x02
#define LSR_PE       0x04
#define LSR_FE       0x08
#define LSR_BREAK    0x10
#define LSR_THEMT    0x20
#define LSR_TXEMT    0x40
#define LSR_RXERR    0x80

#define MCR_DTR      0x01
#define MCR_RTS      0x02
#define MCR_LOOP     0x08
#define MCR_MASK     0x0b

#define MSR_DCTS     0x01
#define MSR_DDSR     0x02
#define MSR_TERI     0x04
#define MSR_DDCD     0x08
#define MSR_CTS      0x10
#define MSR_DSR      0x20
#define MSR_RI       0x40
#define MSR_DCD      0x80

extern void uart_init(void);

#endif
