/* VPort-50 Monitor
   Copyright (c) 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __MACH_H
#define __MACH_H

/* die Reihenfolge ist entscheidend, 
   sie muss struct jmpbuf in setjmp.h entsprechend
*/
#define REG_CPSR 1
#define REG_R0   2
#define REG_R1   3
#define REG_R2   4
#define REG_R3   5
#define REG_R4   6
#define REG_R5   7
#define REG_R6   8
#define REG_R7   9
#define REG_R8  10
#define REG_R9  11
#define REG_R10 12
#define REG_R11 13
#define REG_R12 14
#define REG_R13 15
#define REG_R14 16
#define REG_R15 17

typedef unsigned int addr_t;
typedef unsigned int break_t;
typedef unsigned char mem_t;

/* Register-Manipulation */
extern void clrreg(void);
extern void initreg(addr_t *);
extern void showreg(void);

extern void disasm(addr_t *);

#define NAME "LPC2xxx"
#define RADIX 16
#define WORDSIZE 4
#define WORDLEN_16 8
#define WORDLEN_10 10
#define WORDLEN_8  11
#define IOFMT "%0.wr\n"
#define MEMFMT "%0.br "
#define ADRFMT "%0.wr"
#define DMPFMT_A "%A  "
#define DMPFMT_S "%S\n"
#define BRKINST 0xefffffff
#define STACKPTR 0x40003fe0 /* obere 32 byte fuer IAP reserviert */
#define find_register(t, s, c) find_string(t, s, c, 3)


/* DS-Manipulation entfaellt */
#define DS_VAR(x)
#define STACK(x)
#define CODE(x)
#define RESTORE(x)

/* Trace-Flag */
extern void trace_emulation(void);
extern unsigned int settrace(void);
extern unsigned int untrace(void);
extern unsigned int togtrace(void);
extern unsigned int istrace(void);

#include <common/break.h>

extern unsigned int tflag;
extern struct breakpoint tracepoint;

extern void init(void);

#endif /* __MACH_H */
