/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __V50_H
#define __V50_H

#define V50_OPCN  0xfffe /* On-Chip Peripheral Connection Register */
#define V50_OPSEL 0xfffd /* On-Chip Peripheral Selection Register  */
#define V50_OPHA  0xfffc /* On-Chip Peripheral High Address        */
#define V50_DULA  0xfffb /* DMAU Low Address Register              */
#define V50_IULA  0xfffa /* ICU Low Address Register               */
#define V50_TULA  0xfff9 /* TCU Low Address Register               */
#define V50_SULA  0xfff8 /* SCU Low Address Register               */
#define V50_SCTL  0xfff7 /* System Control Register                */
#define V50_WCY1  0xfff5 /* Wait Cycle Setting Register 1          */
#define V50_WCY2  0xfff6 /* Wait Cycle Setting Register 2          */
#define V50_WCY3  0xffea /* Wait Cycle Setting Register 3          */
#define V50_WMB   0xfff4 /* Programmable Wait Memory Area Setting  */
#define V50_EXWB  0xffed /* Extended Wait Block Select Register    */
#define V50_WSMB  0xffec /* Wait Submemory Block Setting Register  */
#define V50_WIOB  0xffeb /* Wait I/O Block Setting Register        */
#define V50_RFC   0xfff2 /* Refresh Control Register               */
#define V50_SBCR  0xfff1 /* Standby Control Register               */
#define V50_BRC   0xffe9 /* Baud Rate Counter                      */
#define V50_BADR  0xffe1 /* Bank Address Register                  */
#define V50_BSEL  0xffe0 /* Bank Select Register                   */

#define RFC_DISBL 0x00   /* disable Refresh                        */
#define RFC_ENABL 0x80   /* enable Refresh                         */
#define RFC_RTM(x) (x-1) /* timer factor                           */

#define WMB_32  0x0      /* memory sizes                           */
#define WMB_64  0x1
#define WMB_96  0x2
#define WMB_128 0x3
#define WMB_192 0x4
#define WMB_256 0x5
#define WMB_384 0x6
#define WMB_512 0x7
#define WMB_UMB(x) (x)   /* upper memory block                     */
#define WMB_LMB(x) (x<<4)/* lower memory block                     */

#define WCY1_LMW(x) (x&3)/* wait states                            */
#define WCY1_MMW(x) ((x&3)<<2)
#define WCY1_UMW(x) ((x&3)<<4)
#define WCY1_IOW(x) ((x&3)<<6)
#define WCY2_RFW(x) (x&3)
#define WCY2_DMAW(x) ((x&3)<<2)

#define OPSEL_DMAU 0x1   /* enable DMAU                            */
#define OPSEL_ICU  0x2   /* enable ICU                             */
#define OPSEL_TCU  0x4   /* enable TCU                             */
#define OPSEL_SCU  0x8   /* enable ICU                             */

#define OPCN_PF(x) (x&3) /* ref. V50 Hardware Documentation,
			    U11610EJ6V0UM00 p.42
			 */
#define OPCN_IRSW(x) ((x&3)<<2)

#define DMAU_BASE 0xe0   /* base address of DMAU                   */

extern void v50_init();

#endif /* __V50_H */
