;;;   VPort-50 Monitor
;;;   Copyright (c) 2004, Hans Rosenfeld
;;;
;;;   This program is free software; you can redistribute it and/or modify
;;;   it under the terms of the GNU General Public License as published by
;;;   the Free Software Foundation; either version 2, or (at your option)
;;;   any later version.
;;;
;;;   This program is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;   GNU General Public License for more details.
;;;
;;;   You should have received a copy of the GNU General Public License
;;;   along with this program; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;;;   02111-1307, USA.

CPU 186
	
;;; setjmp/longjmp fr C
;;; im Gegensatz zu blichen Versionen bentigen diese Funktionen
;;; kein Argument, es steht zur Speicherung genau ein Speicherbereich
;;; im Stacksegment zur Verfgung.

%include "seg.s"
global	_jmpbuf
_jmpbuf	equ		stackptr
	
;;; der Speicherbereich _jmpbuf ist folgendermassen aufgeteilt:
%define	JMPBUF$AX	_jmpbuf+0
%define JMPBUF$BX	_jmpbuf+2
%define JMPBUF$CX	_jmpbuf+4
%define JMPBUF$DX	_jmpbuf+6
%define JMPBUF$SI	_jmpbuf+8
%define JMPBUF$DI	_jmpbuf+10
%define JMPBUF$DS	_jmpbuf+12
%define JMPBUF$ES	_jmpbuf+14
%define JMPBUF$CS	_jmpbuf+16
%define JMPBUF$SS	_jmpbuf+18
%define JMPBUF$PS	_jmpbuf+20
%define JMPBUF$BP	_jmpbuf+22
%define JMPBUF$SP	_jmpbuf+24
%define JMPBUF$IP	_jmpbuf+26
	
global	_setjmp
_setjmp:
	pushf
	mov	[ss:JMPBUF$AX],ax
	mov	[ss:JMPBUF$BX],bx
	mov	[ss:JMPBUF$CX],cx
	mov	[ss:JMPBUF$DX],dx
	mov	[ss:JMPBUF$SI],si
	mov	[ss:JMPBUF$DI],di
	mov	ax,ds
	mov	[ss:JMPBUF$DS],ax
	mov	ax,es
	mov	[ss:JMPBUF$ES],ax
	mov	ax,cs
	mov	[ss:JMPBUF$CS],ax
	mov	ax,ss
	mov	[ss:JMPBUF$SS],ax
	pop	ax
	mov	[ss:JMPBUF$PS],ax
	mov	[ss:JMPBUF$BP],bp
	mov	bx,sp
	add	bx,2
	mov	[ss:JMPBUF$SP],bx
	mov	ax,[bx-2]
	mov	[ss:JMPBUF$IP],ax
	;; alles gespeichert, raus.
	push	word [ss:JMPBUF$PS]
	mov	ax,[ss:JMPBUF$AX]
	mov	bx,[ss:JMPBUF$BX]
	popf
	ret

extern  _stack	
global	_longjmp
_longjmp:
	mov	ax,[ds:JMPBUF$SS]
	mov	ss,ax
	mov	sp,[ds:JMPBUF$SP]
	push	word [ss:JMPBUF$PS]
	push	word [ss:JMPBUF$CS]
	push	word [ss:JMPBUF$IP]
	mov	ax,[ss:JMPBUF$DS]
	mov	ds,ax
	mov	ax,[ss:JMPBUF$ES]
	mov	es,ax
	mov	bp,[ss:JMPBUF$BP]
	mov	di,[ss:JMPBUF$DI]
	mov	si,[ss:JMPBUF$SI]
	mov	dx,[ss:JMPBUF$DX]
	mov	cx,[ss:JMPBUF$CX]
	mov	bx,[ss:JMPBUF$BX]
	mov	ax,[ss:JMPBUF$AX]
	reti
