/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __SCU_H
#define __SCU_H

#define SCU_BASE 0            /* Basisadresse der SCU              */
#define SCU_SRB  (SCU_BASE)   /* Serial Receive Buffer             */
#define SCU_STB  (SCU_BASE)   /* Serial Transmit Buffer            */
#define SCU_SST  (SCU_BASE+2) /* Serial Status Register            */
#define SCU_SCM  (SCU_BASE+2) /* Serial Command Register           */
#define SCU_SMD  (SCU_BASE+4) /* Serial Mode Register              */
#define SCU_SIMK (SCU_BASE+6) /* Serial Interrupt Masking Register */

#define SMD_RTCLK16 0x02      /* RTCLK frequency divided by 16     */
#define SMD_RTCLK64 0x03      /* RTCLK frequency divided by 64     */
#define SMD_7BITS   0x08      /* 7 bit characters                  */
#define SMD_8BITS   0x0C      /* 8 bit characters                  */
#define SMD_ODD     0x10      /* odd parity                        */
#define SMD_EVEN    0x30      /* even parity                       */
#define SMD_1STOP   0x40      /* 1 stop bit                        */
#define SMD_2STOP   0xC0      /* 2 stop bits                       */

#define SCM_TE      0x01       /* Transmission enabled             */
#define SCM_RE      0x04       /* Reception enabled                */
#define SCM_SBRK    0x08       /* Break transmission = TxD pin low */
#define SCM_ECL     0x10       /* clear error flag                 */
#define SCM_MRDY    0x20       /* Normal ~SRDY output              */

#define SIMK_RECV   0x01       /* RBRDY interrupt masked           */
#define SIMK_XMIT   0x02       /* TBRDY interrupt masked           */

#define SST_TBRDY   0x01       /* transmit buffer ready            */
#define SST_RBRDY   0x02       /* receive buffer ready             */
#define SST_PARITY  0x04       /* parity error                     */
#define SST_OVRUN   0x10       /* overrun error                    */
#define SST_FRAME   0x20       /* framing error                    */
#define SST_BREAK   0x40       /* break state                      */
#define SST_ERROR   (SST_FRAME|SST_OVRUN|SST_PARITY)

extern void scu_init();

#endif /* __SCU_H */
