/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <vport50/scu.h>
#include <vport50/asm.h>

/* scu_init stellt die SCU ein
   8N1 bei 19200 Baud (RTCLK/16)
   Normal ~SRDY output, Clear Error, Receiver & Transmitter enabled
   Interrupts deaktiviert
*/ 
void scu_init()
{
        out(SCU_SMD,  SMD_8BITS|SMD_1STOP|SMD_RTCLK16);
        out(SCU_SCM,  SCM_MRDY|SCM_ECL|SCM_RE|SCM_TE);
        out(SCU_SIMK, SIMK_RECV|SIMK_XMIT);
}

/* getchar liest ein Zeichen von der Console (blockierend),
   verarbeitet Zeilenumbrche
   getchar_nb ist eine nichtblockierende Variante, wenn kein Zeichen
   vorhanden ist wird -1 zurckgegeben
*/
int getchar()
{
        int status, character;
     
        /* warten, bis ein Zeichen da ist, und das Zeichen lesen */
        while((status=in(SCU_SST)&SST_RBRDY) == 0);
        character=in(SCU_SRB);
     
        /* Zeilenumbrche (CR) wandeln wir in ein einzelnes LF */
        if(character == '\r')
                character='\n';
     
        /* wenn es einen Fehler gab, setzen wir die SCU zurck */
        if(status&SST_ERROR)
                out(SCU_SCM, SCM_MRDY|SCM_ECL|SCM_RE|SCM_TE);
     
        return(character&0xff);
}

int getchar_nb()
{
        int status, character;

        if((status=in(SCU_SST)&SST_RBRDY) != 0)
                character=in(SCU_SRB);
        else
                return(-1);
     
        if(character == '\r')
                character='\n';
     
        if(status&SST_ERROR)
                out(SCU_SCM, SCM_MRDY|SCM_ECL|SCM_RE|SCM_TE);
     
        return(character&0xff);
}

/* putchar schreibt ein Zeichen auf die Console (blockierend),
   erzeugt korrekte Zeilenumbrche
*/
void putchar(character)
        int character;
{
        /* vor einem LF kommt immer erstmal ein CR */
        if(character == '\n') 
                putchar('\r');

        while((in(SCU_SST)&SST_TBRDY) == 0);
        out(SCU_STB, character);
}
