/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __MACH_H
#define __MACH_H

/* die Reihenfolge ist entscheidend,
   sie muss struct jmpbuf in setjmp.h entsprechen
*/
#define REG_AX 1
#define REG_BX 2
#define REG_CX 3
#define REG_DX 4
#define REG_SI 5
#define REG_DI 6
#define REG_DS 7
#define REG_ES 8
#define REG_CS 9
#define REG_SS 10
#define REG_PS 11
#define REG_BP 12
#define REG_SP 13
#define REG_IP 14

typedef struct {
        unsigned int seg;
        unsigned int ofs;
} addr_t;

typedef unsigned int break_t;
typedef unsigned char mem_t;

extern void setreg();
extern void clrreg();
extern void initreg();
extern void showreg();
extern void disasm();

#define NAME "VPort-50"
#define RADIX 16
#define WORDSIZE 2
#define WORDLEN_16 4
#define WORDLEN_10 5
#define WORDLEN_8 6
#define IOFMT "%0.br\n"
#define MEMFMT "%0.br "
#define ADRFMT "%0.wr:%0.wr"
#define DMPFMT_A "%A   "
#define DMPFMT_S "  %S\n"
#define BRKINST 0xCC
#define STACKPTR 0x400
#define find_register(t, s, c) find_string(t, s, c, 2)

/* DS-Manipulation */
extern unsigned int stack();
extern unsigned int code();
extern void restore();

#define DS_VAR(x)  unsigned int x;
#define STACK(x)   x = stack()
#define CODE(x)    x = code()
#define RESTORE(x) restore(x)

/* Trace-Flag */
#include <vport50/status.h>
#define settrace() (status.flags|=0x0100)
#define untrace()  (status.flags&=0xfeff)
#define togtrace() (status.flags^=0x0100)
#define istrace()  ((status.flags&0x0100) != 0)

/* bcc tut sich schwer mit const, wird aber auch nicht bentigt */
#define const

extern void init();

#endif /* __MACH_H */
