/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <vport50/icu.h>
#include <vport50/setjmp.h>
#include <vport50/status.h>
#include <vport50/asm.h>
#include <vport50/mach.h>
#include <vport50/addr.h>
#include <common/break.h>
#include <common/stdio.h>

#define TERMINATE 0x14
#define GETCHAR   0x10
#define PUTCHAR   0x11
#define GETCHARW  0x12

/*
  icu_init stellt die ICU ein
  single mode, vector offset 8, normal nesting, FI command mode
*/
void icu_init()
{
        out(ICU_IIW1, IIW1_SELECT|IIW1_II4|IIW1_SINGLE);
        out(ICU_IIW2, IIW2_OFFS(VECT_OFFSET));
        out(ICU_IIW4, IIW4_SELECT);
        out(ICU_IMKW, 0xff);
}

/* Interrupt Processing End Statement */
void clear_interrupt()
{
        out(ICU_IPFW, IPFW_FI);
}

/* Interrupt-Handler, wird aus main.s aufgerufen */
void interrupt_handler(sseg,sptr)
        unsigned int sseg, sptr;
{
        unsigned int intvec;
        unsigned int /* es, ss, ds, di, si, bp, sp, bx, dx, cx, ax, */ ip, cs, flags;
        int i=0;
        addr_t addr;

        intvec = read_word(sseg, sptr+22);
        ip = read_word(sseg, sptr+24);
        cs = read_word(sseg, sptr+26);
        flags = read_word(sseg, sptr+28);

        intvec -= ((unsigned int) handlers)+3;
        intvec /= 3;
     
        switch(intvec) {
        case 0: /* divide by zero */
                printf("\ndivide by zero\n");
                break;

        case 1: /* trace */
                if(cs == jmpbuf.cs) return;
                unbreak();
                if(brkcur != NBRK) {
                        brkcur=NBRK;
                        if(trace == 0) {
                                flags&=0xfeff;
                                write_word(sseg, sptr+28, flags); /* flags im Stack speichern fr Rckkehr */
                                dobreak();
                                return;
                        }
                }
                break;
        case 2: /* NMI */
                if(cs == jmpbuf.cs) return;
                unbreak();
                printf("\ninterrupted\n");
                break;

        case 3: /* breakpoint */
                unbreak();
                ip--;
                set_addr(&addr, cs, ip);
                for(i=0; i!=brkcnt; i++)
                        if(!cmp_addr(&brktbl[i].addr, &addr)) {
                                brkcur=i;
                                flags|=0x0100;
                                break;
                        }
                printf("\nbreakpoint %d reached\n", brkcur);
                break;

        case 4: /* overflow */
                printf("\noverflow\n");
                break;

        case VECT_OFFSET:
        case VECT_OFFSET+1:
        case VECT_OFFSET+2:
        case VECT_OFFSET+3:
        case VECT_OFFSET+4:
        case VECT_OFFSET+5:
        case VECT_OFFSET+6:
        case VECT_OFFSET+7:
                printf("\nHardware-Interrupt %d\n", intvec-VECT_OFFSET);
                clear_interrupt();
                return;

        case GETCHAR:
                write_word(sseg, sptr+20, getchar_nb());
                return;

        case PUTCHAR:
                putchar(read_word(sseg, sptr+20));
                return;

        case GETCHARW:
                write_word(sseg, sptr+20, getchar());
                return;

        case TERMINATE:
                printf("\nterminated\n");
                break;

        default:
                printf("\nInterrupt %d\n", intvec);
                break;
        }

        if(cs != jmpbuf.cs) {
                status.es = read_word(sseg, sptr);
                status.ss = read_word(sseg, sptr+2);
                status.ds = read_word(sseg, sptr+4);
                status.di = read_word(sseg, sptr+6);
                status.si = read_word(sseg, sptr+8);
                status.bp = read_word(sseg, sptr+10);
                status.sp = read_word(sseg, sptr+12) + 8; /* intvec, ip, cs, flags */
                status.bx = read_word(sseg, sptr+14);
                status.dx = read_word(sseg, sptr+16);
                status.cx = read_word(sseg, sptr+18);
                status.ax = read_word(sseg, sptr+20);
                status.cs = cs;
                status.ip = ip;
                status.flags = flags;
                showreg();
                set_addr(&addr, cs, ip);
                disasm(&addr);
        }
        longjmp();
}
