/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __ICU_H
#define __ICU_H

#define ICU_BASE 0x0018
#define ICU_IIW1 (ICU_BASE)    /* ICU Initialization Word 1 */
#define ICU_IIW2 (ICU_BASE+2)  /* ICU Initialization Word 2 */
#define ICU_IIW3 (ICU_BASE+2)  /* ICU Initialization Word 3 */
#define ICU_IIW4 (ICU_BASE+2)  /* ICU Initialization Word 4 */
#define ICU_IPFW (ICU_BASE)    /* ICU Priority, Finish Word */
#define ICU_IMDW (ICU_BASE)    /* ICU Mode Word             */
#define ICU_IMKW (ICU_BASE+2)  /* ICU Mask Word             */
#define ICU_IRQ  (ICU_BASE)    /* ICU Interrupt Request     */
#define ICU_IIS  (ICU_BASE)    /* ICU Interrupt In-Service  */
#define ICU_IPOL (ICU_BASE)    /* ICU Interrupt Polling     */

#define IIW1_SELECT 0x10       /* select IIW1               */
#define IIW1_II4    0x01       /* write to IIW4             */
#define IIW1_SINGLE 0x02       /* Single mode               */
#define IIW1_LEVEL  0x08       /* Level trigger             */
#define IIW2_OFFS(x) (x&0xf8)  /* vector offset             */
#define IIW3_CASC(x) (0x1<<(x))/* slave interrupt line      */
#define IIW4_SELECT 0x1        /* select IIW4               */
#define IIW4_SELF   0x2        /* Self-FI mode              */
#define IIW4_EXTN   0x10       /* Extended Nesting Mode     */

#define IPFW_FI     0x20       /* Finish Interrupt          */

#define VECT_OFFSET 8          /* Interrupt-Vector Offset   */

extern void icu_init();

#endif /* __ICU_H */
