/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <vport50/mach.h>
#include <common/stdio.h>

/* scan_addr liest eine V50-Adresse aus einem String
   das Adreformat ist [[seg]:]ofs
*/
char* scan_addr(string, addr)
        char *string;
        addr_t *addr;
{
        unsigned int tmp;
        char *ptr = string;
        DS_VAR(ds);

        STACK(ds);
        ptr = scann(ptr, &tmp, 0);
        if(*ptr == ':') {
                addr->seg = tmp;
                ptr = scann(ptr+1, &tmp, 0);
        }
        addr->ofs = tmp;
        RESTORE(ds);
        return(ptr);
}

/* add_addr, sub_addr, inc_addr, dec_addr, cmp_addr, cpy_addr, set_addr,
   clr_addr - V50-Adressen verarbeiten
*/
void add_addr(addr, val)
        addr_t *addr;
        unsigned int val;
{
        register unsigned int seg, ofs;
        DS_VAR(ds);
     
        STACK(ds);
        seg = addr->seg;
        ofs = addr->ofs;

        if(ofs > ofs + val)
                seg += 0x1000;
        ofs += val;
     
        addr->seg = seg;
        addr->ofs = ofs;
     
        RESTORE(ds);
}

void sub_addr(addr, val)
        addr_t *addr;
        unsigned int val;
{
        register unsigned int seg, ofs;
        DS_VAR(ds);

        STACK(ds);
        seg = addr->seg;
        ofs = addr->ofs;
     
        if(ofs - val > ofs)
                seg -= 0x1000;
        ofs -= val;
     
        addr->seg = seg;
        addr->ofs = ofs;
     
        RESTORE(ds);
}

void inc_addr(addr)
        addr_t *addr;
{
        register unsigned int seg, ofs;
        DS_VAR(ds);

        STACK(ds);
        seg = addr->seg;
        ofs = addr->ofs;

        ofs++;
        if(ofs == 0)
                seg += 0x1000;
     
        addr->seg = seg;
        addr->ofs = ofs;

        RESTORE(ds);
}

void dec_addr(addr)
        addr_t *addr;
{
        register unsigned int seg, ofs;
        DS_VAR(ds);

        STACK(ds);
        seg = addr->seg;
        ofs = addr->ofs;

        if(ofs == 0)
                seg -= 0x1000;
        ofs--;

        addr->seg = seg;
        addr->ofs = ofs;

        RESTORE(ds);
}

int cmp_addr(src, dst)
        addr_t *src;
        addr_t *dst;
{
        unsigned long int s, d;
        int r;
        DS_VAR(ds);
     
        STACK(ds);
        s = (((unsigned long int) src->seg) << 4) + (unsigned long int) src->ofs;
        d = (((unsigned long int) dst->seg) << 4) + (unsigned long int) dst->ofs;
        RESTORE(ds);

        if(s == d) r= 0;
        if(s > d)  r= 1;
        if(s < d)  r=-1;
        return(r);
}

void cpy_addr(src, dst)
        addr_t *src;
        addr_t *dst;
{
        DS_VAR(ds);

        STACK(ds);
        dst->seg = src->seg;
        dst->ofs = src->ofs;
        RESTORE(ds);

        return;
}

void set_addr(addr, seg, ofs)
        addr_t *addr;
        unsigned int seg, ofs;
{
        DS_VAR(ds);

        STACK(ds);
        addr->seg = seg;
        addr->ofs = ofs;
        RESTORE(ds);

        return;
}

void clr_addr(addr)
        addr_t *addr;
{
        DS_VAR(ds);

        STACK(ds);
        addr->seg = 0;
        addr->ofs = 0;
        RESTORE(ds);

        return;
}

/* print_addr gibt eine V50-Adresse auf der Console aus, fr printf() */
void print_addr(addr)
        addr_t *addr;
{
        DS_VAR(ds);

        STACK(ds);
        printf(ADRFMT, addr->seg, addr->ofs);
        RESTORE(ds);

        return;
}

/* writeb, writew, readb, readw - Wrapper fr ASM-Routinen *_byte und *_word */
void writeb(addr, val)
        addr_t *addr;
        unsigned int val;
{
        DS_VAR(ds);

        STACK(ds);
        write_byte(addr->seg, addr->ofs, val);
        RESTORE(ds);

        return;
}

void writew(addr, val)
        addr_t *addr;
        unsigned int val;
{
        DS_VAR(ds);

        STACK(ds);
        write_word(addr->seg, addr->ofs, val);
        RESTORE(ds);

        return;
}

unsigned int readb(addr)
        addr_t *addr;
{
        unsigned int tmp;
        DS_VAR(ds);

        STACK(ds);
        tmp = read_byte(addr->seg, addr->ofs);
        RESTORE(ds);

        return(tmp&0xff);
}

unsigned int readw(addr)
        addr_t *addr;
{
        unsigned int tmp;
        DS_VAR(ds);

        STACK(ds);
        tmp = read_word(addr->seg, addr->ofs);
        RESTORE(ds);

        return(tmp);
}
