/* VPort-50 Monitor
   Copyright (c) 2005, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __PRINTF_H
#define __PRINTF_H

/* 2.11BSD cc legt die Argumente einfach nur auf dem Stack ab,
   kennt keine Ellipsen und auch kein stdarg.h
*/

typedef int* va_list;
#define va_start(list, arg) list = ((va_list) &arg)
#define va_end(list)
#define va_arg(list, type) *((type *) (++list))

/* printf Deklaration */
extern void printf();

/* printf Funktionskopf: K&R-Syntax, keine Ellipse */
#define PRINTF(arg) printf(arg) char *arg;

#endif
