/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __CONS_H
#define __CONS_H

#define CONS_CSR     0177560 /* Standard-CSR fr PDP-11 Konsole */

/* Struktur zum Zugriff auf die Konsolen-Register */
struct cons {
        unsigned int rcsr;   /* receiver control/status register */
        unsigned int rbuf;   /* receiver data buffer register    */
        unsigned int xcsr;   /* transmit control/status register */
        unsigned int xbuf;   /* transmit data buffer register    */
} *cons = (struct cons *) CONS_CSR;

#define RCSR_RDRENB       01 /* Reader Enable    */
#define RCSR_INTENB     0100 /* Interrupt Enable */
#define RCSR_DONE       0200 /* Receiver Done    */
#define RCSR_STATUS  0100000 /* Receiver Status  */

#define RBUF_ERROR   0100000 /* Channel Error Status */
#define RBUF_OVRRUN  0040000 /* Overrun Error    */
#define RBUF_FRAMNG  0020000 /* Framing Error    */
#define RBUF_PARITY  0010000 /* Parity Error     */

#define XCSR_READY      0200 /* Transmit Ready   */
#define XCSR_INTENB     0100 /* Interrupt Enable */
#define XCSR_BREAK        01 /* Transmit Break   */

extern void cons_init();

#endif /* __CONS_H */
