/* VPort-50 Monitor
   Copyright (c) 2004 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <common/stdio.h>
#include <common/string.h>
#include <common/mem.h>
#include <mach/addr.h>
#include <mach/mach.h>
#include <mach/setjmp.h>

/* dump gibt einen hexadezimalen Speicherabzug ab Adresse addr aus.
   Rckgabewert ist die Anzahl ausgegebener Bytes, die Adresse wird
   nicht verndert.
*/ 
unsigned int dump(addr)
        addr_t *addr;
{
        mem_t buf[16/sizeof(mem_t)];
        unsigned int i, j;

        for(i=0; i!=DUMPLINES; i++) {
                printf(DMPFMT_A, addr);
                for(j=0; j!=16/sizeof(mem_t); j++) {
                        buf[j]=read_mem(addr);
                        printf(MEMFMT, buf[j]);
                        add_addr(addr, sizeof(mem_t));
                }
                printf(DMPFMT_S, buf);
        }
        sub_addr(addr, DUMPLINES*16);
        return(DUMPLINES*16);
}

/* edit fllt den Speicher ab addr mit dem Inhalt von ptr
   die Anzahl der geschrieben Bytes wird zurckgegeben, addr wird verndert
*/
void edit(ptr, addr, val, cnt)
        char *ptr;
        addr_t *addr;
        unsigned int *val;
        unsigned int *cnt;
{
        int tmp;
        DS_VAR(ds);


        STACK(ds);
        for(;;) {
                ptr=skip(ptr, " \t\n");
                switch(*ptr++) {
                case 0:
                        RESTORE(ds);
                        return;
                case '"':
                        while(*ptr && *ptr != '\n' && *ptr != '"') {
                                writeb(addr, *ptr++);
                                inc_addr(addr);
                        }
                        ptr++;
                        break;
                case ':':
                        printf("parse error: illegal character: :\n");
                        longjmp();
                default:
                        ptr=scann(ptr-1, val, 0);
                        ptr=skip(ptr," \t\n");
                        if(*ptr == ',') {
                                ptr=skip(ptr+1," \t\n");
                                ptr=scann(ptr, cnt, 0);
                                tmp=*cnt;
                        } else tmp=1;
                        if(tmp) {
                                odd_addr_inc(addr);
                                do {
                                        write_mem(addr, *val);
                                        add_addr(addr, sizeof(mem_t));
                                } while(--tmp);
                        }
                }
        }
}

/* copy kopiert einen Speicherblock der Grsse cnt von saddr an daddr
   berlappungen werden korrekt behandelt
*/
void move(saddr, daddr, cnt)
        addr_t *saddr;
        addr_t *daddr;
        unsigned int cnt;
{
        unsigned int dir=0, tmp = cnt;

        if(!cmp_addr(saddr, daddr) || cnt == 0) return;

        if(cmp_addr(saddr, daddr) < 0) {
                add_addr(saddr, cnt);
                if(cmp_addr(saddr, daddr) > 0)
                        dir=1;
                sub_addr(saddr, cnt);
        } else dir=0;

        if(dir) {
                add_addr(saddr, cnt-1);
                add_addr(daddr, cnt-1);
                do {
                        writeb(daddr, readb(saddr));
                        dec_addr(saddr);
                        dec_addr(daddr);
                } while(--cnt);
                add_addr(saddr, tmp+1);
                add_addr(daddr, tmp+1);
        } else {
                do {
                        writeb(daddr, readb(saddr));
                        inc_addr(saddr);
                        inc_addr(daddr);
                } while(--cnt);
        }
}
