/* VPort-50 Monitor
   Copyright (c) 2005, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <arm/uart.h>
#include <arm/asm.h>
#include <arm/lpc2xxx.h>

/* UART0 ist Console */
struct uart * const uart = (struct uart *) UART0_BASE;

/* Initialisierung eines UART als Console
   Parameter 19200 8N1, keine Interrupts (Polling)
   nach der Initialisierung werden die FIFOs freigeschaltet
*/
   
void uart_init(void)
{
        uart->ier = 0;
        uart->lcr = LCR_DLAB;
        uart->dll = LO(BAUD(19200));
        uart->dlm = HI(BAUD(19200));
        uart->lcr = LCR_WLEN(8) | LCR_STOP(1);
        uart->fcr = FCR_FENB;
}

/* getchar liest ein Zeichen von der Console (blockierend),
   verarbeitet Zeilenumbrche
   getchar_nb ist eine nicht-blockierende Variante, wenn kein Zeichen
   vorhanden ist wird -1 zurckgegeben
*/
int getchar(void)
{
        int character;
     
        while((uart->lsr & LSR_RXRDY) == 0);
        character = uart->rbr;

        if(character == '\r')
                character = '\n';
     
        return(character);
}

int getchar_nb(void)
{
        int character;

        if((uart->lsr & LSR_RXRDY) != 0)
                character = uart->rbr;
        else
                return(-1);

        if(character == '\r')
                character = '\n';

        return(character);
}

/* putchar schreibt ein Zeichen auf die Console (blockierend),
   erzeugt korrekte Zeilenumbrche
*/
void putchar(int character)
{
        if(character == '\n')
                putchar('\r');
     
        while((uart->lsr & LSR_THEMT) == 0);
        uart->thr = character;
}
