/* VPort-50 Monitor
   Copyright (c) 2005, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __LPC2XXX_H
#define __LPC2XXX_H

#define FLASH_START 0x00000000
#define SRAM_START  0x40000000
#define ERAM_START  0x80000000

#define WD_BASE     0xe0000000
#define TIMER0_BASE 0xe0004000
#define TIMER1_BASE 0xe0008000
#define UART0_BASE  0xe000c000
#define UART1_BASE  0xe0010000
#define PWM_BASE    0xe0014000
#define I2C_BASE    0xe001c000
#define SPI0_BASE   0xe0020000
#define RTC_BASE    0xe0024000
#define GPIO_BASE   0xe0028000
#define PIN_BASE    0xe002c000
#define SPI1_BASE   0xe0030000
#define ADC_BASE    0xe0034000

#define CAN_AFRAM   0xe0038000
#define CAN_AFREG   0xe003c000
#define CANC_BASE   0xe0040000
#define CAN1_BASE   0xe0044000
#define CAN2_BASE   0xe0048000
#define CAN3_BASE   0xe004c000
#define CAN4_BASE   0xe0050000

#define MAM_BASE    0xe01fc000
#define MEM_BASE    0xe01fc040
#define PLL_BASE    0xe01fc080
#define PWR_BASE    0xe01fc0c0
#define VPB_BASE    0xe01fc100
#define EXT_BASE    0xe01fc140

#define EMC_BASE    0xffe00000
#define VIC_BASE    0xfffff000
#define VIC_ADDR    0xfffff100
#define VIC_CTRL    0xfffff200

/* PIN Select */
struct pin {
        volatile unsigned long sel0;
        volatile unsigned long sel1;
        unsigned long s2, s3, s4;
        volatile unsigned long sel2;
};

/* Memory Accelerator Module */
struct mam {
        volatile unsigned long cr;
        volatile unsigned long tim;
};

#define MAM_DSBL     0x0
#define MAM_PENB     0x1
#define MAM_FENB     0x2
#define MAM_CYCLE(x) ((x)&0x7)

extern void mam_init(void);

/* Memory Mapping Control */
struct mem {
        volatile unsigned long map;
};

#define MEM_BOOT  0
#define MEM_FLASH 1
#define MEM_SRAM  2
#define MEM_ERAM  3

/* Phase Locked Loop */
struct pll {
        volatile unsigned long con;
        volatile unsigned long cfg;
        volatile unsigned long stat;
        volatile unsigned long feed;
};

#define PLL_FEED1   0xaa
#define PLL_FEED2   0x55
#define PLL_PSEL(x) ((((x) == 8 ? 3 : (x>>1))&0x3)<<5)
#define PLL_MSEL(x) (((x)-1)&0x1f)
#define PLL_ENBL    0x01
#define PLL_CONN    0x02
#define PLL_LOCK    0x0400

extern void pll_init(void);

/* Power Control */
struct pwr {
        volatile unsigned long con;
        volatile unsigned long conp;
};

#define PWR_IDLE 0x01
#define PWR_DOWN 0x02
#define PWR_TIM0 0x00000002
#define PWR_TIM1 0x00000004
#define PWR_URT0 0x00000008
#define PWR_URT1 0x00000010
#define PWR_PWM0 0x00000020
#define PWR_I2C  0x00000080
#define PWR_SPI0 0x00000100
#define PWR_RTC  0x00000200
#define PWR_SPI1 0x00000400
#define PWR_EMC  0x00000800
#define PWR_AD   0x00001000
#define PWR_CAN1 0x00002000
#define PWR_CAN2 0x00004000
#define PWR_CAN3 0x00008000
#define PWR_CAN4 0x00010000

/* VLSI Peripheral Bus */
struct vpb {
        volatile unsigned long div;
};

#define VPB_4TH  0x00
#define VPB_SAME 0x01
#define VPB_HALF 0x10
 
/* External Interrupts */
struct ext {
        volatile unsigned long flag;
        volatile unsigned long wake;
        volatile unsigned long mode;
        volatile unsigned long polar;
};

#define EXT_INT(x)  (1<<(x))
#define EXT_WAKE(x) (1<<(x))
#define EXT_EDGE(x) (1<<(x))
#define EXT_HIGH(x) (1<<(x))

/* External Memory Controller */
struct emc {
        volatile unsigned long bcfg[4];
};

#define EMC_IDCY(x) (((x)-1)&0xf)
#define EMC_WST1(x) ((((x)-3)&0x1f)<<5)
#define EMC_RBLE    0x00000400
#define EMC_WST2(x) ((((x)-3)&0x1f)<<11)
#define EMC_BUSERR  0x01000000
#define EMC_WPERR   0x02000000
#define EMC_WP      0x04000000
#define EMC_BM      0x08000000
#define EMC_MW(x)   0x30000000&((x)<<24)

/* In Application Programming */
struct iap_param {
        unsigned long code;
        unsigned long p[4];
};

#define IAP_PREPARE 50
#define IAP_COPY    51
#define IAP_ERASE   52
#define IAP_CHECK   53
#define IAP_PARTID  54
#define IAP_VERSION 55
#define IAP_COMPARE 56

#define IAP_CMD_SUCCESS 0
#define IAP_CMD_INVALID 1
#define IAP_SRC_ADDRERR 2
#define IAP_DST_ADDRERR 3
#define IAP_SRC_ADDRMAP 4
#define IAP_DST_ADDRMAP 5
#define IAP_CNT_INVALID 6
#define IAP_SEC_INVALID 7
#define IAP_SEC_NOTBLNK 8
#define IAP_SEC_NOTPREP 9
#define IAP_CMP_INEQUAL 10
#define IAP_BSY 11

#define IAP_LOCATION 0x7ffffff1

#include <arm/addr.h>
extern void write_flash(addr_t addr, char *mem);
extern int has_flash(void);

#define PID_FLASH(x) ((x == 0x0301ff12) ? 0 : (x & 1) + 1)

#endif /* __LPC2XXX_H */
