/*  pokerd - a classical draw poker server
 *  Copyright (C) 2001,2003 Hans P. Rosenfeld <rosenfeld@grumpf.hope-2000.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __PLAYER_H
#define __PLAYER_H

#include "cards.h"
#include "check.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define ENTRY     2000           /* each player gets $2000 at the beginning        */
#define MIN_BET      2           /* the minmal bet a player can set is $2          */

#define S_WAIT       0           /* players can still join                         */
#define S_ANTE       1           /* all players set their ante and got their cards */
#define S_NEXTROUND  2           /* waiting for discards                           */
#define S_CARDS      3           /* all players got their replacement cards        */
#define S_SHOWDOWN   4           /* showdown                                       */
#define S_REINIT     5           /* not really a game stage, this tells loop() to clean up and return */

#define F_NONE       0           /* no flags */
#define F_PASS       1           /* passing & betting allowed */
#define F_RAISE      2           /* raising allowed */
#define F_RAISED     4           /* there are outstanding bets to be called */

#define BUFSIZE 256

typedef enum { ACTIVE, INACTIVE } stat_l;

struct player_t {
     char *name;
     struct card_deck_t *cards;
     struct comb_t *hand;
     char *addr;
     stat_l state;
     int money;
     int dealer;
     int lastraise;
     int broken;
     FILE *socket;
     struct player_t *next;
     struct player_t *prev;
};

struct table_t {
     struct card_deck_t *card_deck;
     struct card_deck_t *discard;
     struct player_t *dealer;
     struct player_t *active;
     struct player_t *raiser;
     int count;
     int act_cnt;
     int dis_cnt;
     int raise;
     int pot;
     int limit;
     int stage;
     int flags;
};

extern struct player_t *new_player(int sock);
extern int check_name(struct table_t *table, char *name);
extern int insert_player(struct player_t *player, struct table_t *table);
extern int remove_player(struct player_t *player, struct table_t *table);
extern int rotate(struct table_t *table);
extern int next_turn(struct table_t *table);
extern void send_to_player(struct player_t *player, char *buf);
extern void send_to_all_players(struct table_t *table, char *buf);
extern char *read_from_player(struct player_t *player, char *buf, int size);
extern char *get_stage(struct table_t *table);
extern void end_round(struct table_t *table);
extern void end_round_win(struct table_t *table);
extern struct player_t *get_next_active_player(struct player_t *active);
extern void clear_raises(struct table_t* table);
extern void check_round(struct table_t *table);
extern void ante(struct table_t *table);
extern void deal(struct table_t *table);
void showdown(struct table_t *table);

#endif
