/*  pokerd - a classical draw poker server
 *  Copyright (C) 2001,2003 Hans P. Rosenfeld <rosenfeld@grumpf.hope-2000.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __CHECK_H
#define __CHECK_H

#include "cards.h"

#define HIGH_STRAIGHT  2 /* != 0 && != 1 to avoid confusions */

#define HIGH_CARD      0 
#define ONE_PAIR       1
#define TWO_PAIRS      2
#define TRIPS          3
#define STRAIGHT       4
#define FLUSH          5
#define FULL_HOUSE     6
#define QUADS          7
#define STRAIGHT_FLUSH 8
#define ROYAL_FLUSH    9

struct comb_t {
     int comb;
     int cards[5];
     int hcards;
     int kcards;
};

extern struct comb_t *check(struct card_deck_t *card_deck);
extern int compare_combs(struct comb_t *comb1, struct comb_t *comb2);
extern char* get_combination(struct comb_t *comb);
#endif

