/*  poker - a very limited client for pokerd
 *  Copyright (C) 2003 Hans P. Rosenfeld <rosenfeld@grumpf.hope-2000.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */
		 
#include <curses.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <fcntl.h>

#define DEF_PORT 65535

int init_sock(int argc, char **argv);
int loop(int conn);
int sigio_handler(int sig);
static WINDOW *output;
static FILE *connection;

int main (int argc, char **argv)
{
     int exitcode=0, conn;
     
     conn=init_sock(argc, argv);
     initscr();
     clear();
     exitcode=loop(conn);
     endwin();
     return(exitcode);
}

int init_sock(int argc, char **argv)
{
     int sock,conn;
     struct sockaddr_in addr;
     struct hostent *host;
     struct in_addr inaddr;
     
     if(argc < 2) {
	  fprintf(stderr, "usage: poker hostname [port]\n");
	  fprintf(stderr, "if the port is omitted, the default of %d will be used.\n", DEF_PORT);
	  exit(1);
     }
     
     if(inet_aton(argv[1], &inaddr))
	  host=gethostbyaddr((char *) &inaddr, sizeof(inaddr), AF_INET);
     else
	  host=gethostbyname(argv[1]);
     if(host==NULL) {
	  fprintf(stderr, "name resolution failed for %s: %s\n", argv[1], hstrerror(h_errno));
	  exit(2);
     }
     memset(&addr, 0, sizeof(addr));
     addr.sin_family=AF_INET;
     memcpy(&addr.sin_addr, host->h_addr_list[0], sizeof(addr.sin_addr));
     addr.sin_port=0;
     if(argc>=3) 
	  addr.sin_port=htons(atoi(argv[2]));
     if(addr.sin_port==0)
	  addr.sin_port=htons(DEF_PORT);
     if((sock=socket(PF_INET, SOCK_STREAM, 0))<0) {
	  perror("socket() failed");
	  exit(3);
     }
     if(connect(sock, (struct sockaddr *) &addr, sizeof(addr))<0) {
	  perror("connect() failed");
	  exit(4);
     }
     fcntl(sock, F_SETOWN, getpid());
     fcntl(sock, F_SETFL, O_ASYNC|O_NONBLOCK);
     return(sock);
}
  
int loop(int conn)
{
     char buf[4096];
     int c, offset=0;
     WINDOW *input;
     int outx=0, outy=0;
     connection=fdopen(conn, "a+");
     signal(SIGIO, (void *) sigio_handler);
     output=newwin(LINES-1, COLS, 0, 0);
     scrollok(output, TRUE);
     input=newwin(1, COLS, LINES-1, 0);
     wrefresh(input);
     for(;;) {
	  wgetnstr(input, buf, 4095);
	  wmove(input, 0, 0);
	  wclrtoeol(input);
	  wrefresh(input);
	  fputs(buf, connection);
	  fputs("\r\n", connection);
	  sigio_handler(0);
     } 
     return(0);
}

int sigio_handler(int sig)
{
     char buf[4096];
     while(fgets(buf, 4095, connection)!=NULL) {
	  waddstr(output, buf);
	  wrefresh(output);
	  if(strcmp(buf, "Bye\n")==0) {
	       endwin();
	       exit(0);
	  }
     }
     signal(SIGIO, (void *) sigio_handler);
}
