/*  pokerd - a classical draw poker server
 *  Copyright (C) 2001,2003 Hans P. Rosenfeld <rosenfeld@grumpf.hope-2000.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __CARDS_H
#define __CARDS_H

#include <stdio.h>
#include <stdarg.h>

struct card_t {
     int color;
     int number;
     struct card_t *next;
     struct card_t *prev;
};

struct card_deck_t {
     int count;
     struct card_t *first;
     struct card_t *last;
};
  
extern char *get_color(struct card_t *card);
extern char *get_number(struct card_t *card);
extern struct card_t *get_first_card(struct card_deck_t *card_deck);
extern struct card_t *get_last_card(struct card_deck_t *card_deck);
extern struct card_t *pop_first_card(struct card_deck_t *card_deck);
extern struct card_t *pop_last_card(struct card_deck_t *card_deck);
extern struct card_deck_t *push_first_card(struct card_t *card, struct card_deck_t *card_deck);
extern struct card_deck_t *push_last_card(struct card_t *card, struct card_deck_t *card_deck);
extern struct card_deck_t *initialize_card_deck(void);
extern struct card_deck_t *initialize_empty_card_deck(void);
extern struct card_deck_t *shuffle_card_deck(struct card_deck_t *card_deck);
extern struct card_deck_t *lift_card_deck(struct card_deck_t *card_deck);
extern void print_card_deck(FILE *stream, struct card_deck_t *card_deck);
extern int snprint_card_deck(char *buf, int size, struct card_deck_t *card_deck);
extern void print_card(FILE *stream, struct card_t *card);
extern int snprint_card(int i, char *buf, int size, struct card_t *card);
extern struct card_deck_t *sort_card_deck_by_number(struct card_deck_t *card_deck);
extern struct card_deck_t *sort_card_deck_by_name(struct card_deck_t *card_deck);
extern void dis_card_deck(struct card_deck_t *card_deck);

#endif
