/* 
 * Copyright (c) 2003, Hans Rosenfeld <rosenfeld@grumpf.hope-2000.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * --------------------------------------------------------------
 * BASED ON
 *      $NetBSD: if_tun.h,v 1.10 2001/10/31 20:08:17 atatat Exp $
 * 
 * Copyright (c) 1988, Julian Onions <jpo@cs.nott.ac.uk>
 * Nottingham University 1987.
 *
 * AND ON
 *	$Id: if_tap.h,v 1.1 2000/04/24 20:47:33 maxk Exp $
 *
 * Copyright (c) 1999 Maksim Yevmenkin <m_evmenkin@yahoo.com>
 * All rights reserved.
 *
 * WHICH ITSELF IS BASED ON
 *      $NetBSD: if_tun.h,v 1.5 1994/06/29 06:36:27 cgd Exp $
 *
 * Copyright (c) 1988, Julian Onions <jpo@cs.nott.ac.uk>
 * Nottingham University 1987.
 *
 * --------------------------------------------------------------
 *
 * This driver takes packets off a virtual ethernet interface and
 * hands them up to a user process and vice-versa. It is basically
 * modified if_tun that processes ethernet frames instead of raw
 * IP packets.
 * 
 */

#ifndef _NET_IF_TAP_H_
#define _NET_IF_TAP_H_

#ifdef _KERNEL
struct tap_softc {
	u_short	tap_flags;		/* misc flags */
#define	TAP_OPEN	0x0001
#define	TAP_INITED	0x0002
#define	TAP_RCOLL	0x0004
#define	TAP_IASET	0x0008
#define	TAP_DSTADDR	0x0010
#define	TAP_RWAIT	0x0040
#define	TAP_ASYNC	0x0080
#define	TAP_NBIO	0x0100

#define	TAP_READY	(TAP_OPEN | TAP_INITED)

	struct	ethercom tap_ec;	/* the interface */
#define tap_if	tap_ec.ec_if
	int	tap_pgrp;		/* the process group - if any */
	struct	selinfo	tap_rsel;	/* read select */
	struct	selinfo	tap_wsel;	/* write select (not used) */
#if NBPFILTER > 0
	caddr_t		tap_bpf;
#endif
};
#endif	/* _KERNEL */

struct tapinfo {
        int     baudrate;               /* linespeed */
	short   mtu;                    /* maximum transmission unit */
	u_char  type;                   /* ethernet, tokenring, etc. */
	u_char  dummy;                  /* place holder */
};

/* ioctl's for get/set debug */
#define	TAPSDEBUG	_IOW('t', 90, int)
#define	TAPGDEBUG	_IOR('t', 89, int)
#define	TAPSIFINFO	_IOW('t', 88, int)
#define	TAPGIFINFO	_IOW('t', 87, int)

#endif /* !_NET_IF_TAP_H_ */
