/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

   Initialisierung der CPU-integrierten Peripherie
*/

#include <vport50/v50.h>
#include <vport50/scu.h>
#include <vport50/tcu.h>
#include <vport50/icu.h>
#include <vport50/asm.h>

/*
  v50_init richtet die CPU ein
  (Speichergrssen, Refresh, IO-Adressen, ...)
  siehe NEC Document No. U11610EJ6V0UM00
*/
void v50_init()
{
        out(V50_RFC,   RFC_DISBL);
        out(V50_WMB,   WMB_LMB(WMB_256)|WMB_UMB(WMB_128));
        out(V50_WCY1,  WCY1_LMW(0)|WCY1_MMW(0)|WCY1_UMW(3)|WCY1_IOW(3));
        out(V50_WCY2,  WCY2_RFW(3)|WCY2_DMAW(3));
        out(V50_SULA,  SCU_BASE);
        out(V50_TULA,  TCU_BASE);
        out(V50_IULA,  ICU_BASE);
        out(V50_DULA,  DMAU_BASE);
        out(V50_OPHA,  0x00);
        out(V50_OPSEL, OPSEL_DMAU|OPSEL_ICU|OPSEL_TCU|OPSEL_SCU);
        out(V50_OPCN,  OPCN_PF(3)|OPCN_IRSW(3));
}

/*
  tcu_init stellt die TCU ein
  clock frequency divided by 4
  TCT#1 counter mode 3, 0x000d
*/
void tcu_init()
{
        out(TCU_TCKS, TCKS_PS04);
        out(TCU_TMD,  TMD_CMODE(3)|TMD_WORD|TMD_TCT1);
        out(TCU_TCT1, 0x0d);
        out(TCU_TCT1, 0x00);
}

/* Wrapper fr Initialisierungen */
void init()
{
        v50_init();
        icu_init();
        tcu_init();
        scu_init();
        sti();
}
