;;;   VPort-50 Monitor
;;;   Copyright (c) 2004, Hans Rosenfeld
;;;
;;;   This program is free software; you can redistribute it and/or modify
;;;   it under the terms of the GNU General Public License as published by
;;;   the Free Software Foundation; either version 2, or (at your option)
;;;   any later version.
;;;
;;;   This program is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;   GNU General Public License for more details.
;;;
;;;   You should have received a copy of the GNU General Public License
;;;   along with this program; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;;;   02111-1307, USA.

CPU 186
extern	_monitor
extern	_interrupt_handler

%include "seg.s"

;;; Eintrittspunkt, wird vom Reset-Vektor angesprungen
global	_main
_main:
	cli
	cld
	mov	ax,stackseg
	mov	ss,ax
	mov	sp,stackptr

	;; Einrichten der Interrupt-Vektoren
	xor	ax,ax		; Datensegment auf 0
	mov	ds,ax
	mov	ax,cs		; die Routinen liegen im Codesegment
	mov	cx,0xff
	mov	dl,_handlers.end-_handlers ; Abstand zweier Interrupt-Handler
.loop:	push	ax              ; CS
	mov	ax,cx           ; Interrupt-Nummer
	mov	bx,cx           ; dito
	shl	bx,2            ; Vektor errechnen
	mul	dl              ; Nummer * Abstand
	add	ax,_handlers    ; + _handler == Offset fr Vektor
	mov	word [bx],ax    ; Offset speichern
	pop	ax
	mov	word [bx+2],ax  ; Segment (CS) speichern
	loop	.loop
	xor	bx,bx           ; Interrupt 0
	mov	word [bx+2],ax  ; Segment (CS) speichern
	mov	word [bx],_handlers ; Offset speichern

        mov     ax,ss           ; der Monitor erwartet DS = SS
        mov     ds,ax
	call	_monitor	; und los gehts.
	;; kehrt nicht zurck, und wenn doch... wen juckts?
	hlt

;;; die einzelnen Interrupt-Handler rufen die C-Funktion interrupt_handler()
;;; auf, interrupt_handler() berechnet die Interrupt-Nummer aus der
;;; Rcksprungadresse des call. Das ist die speichersparendste Variante (3 Bytes
;;; pro Vektor), jede andere Methode wr mehr als doppelt so gro.
global	_handlers
_handlers:
	call	.common
.end:	
%rep		255
	call	.common
%endrep
.common:
        pusha
	push	ds
        push    ss
	push	es
        ;; aktueller Zustand auf Stack gesichert (wo auch immer das ist)
        mov     ax,stackseg     ; in jedem Fall soll DS auf den Monitor-Stack zeigen
        mov     ds,ax
        mov     ax,ss
        mov     bx,sp
        cmp     ax,stackseg
        jz      .moni
        ;; sollten wir uns nicht bereits auf dem Monitor-Stack befinden, schalten wir auf jenen um
        mov     cx,stackseg
        mov     dx,intstack
        mov     ss,cx
        mov     sp,dx
.moni:  
        push    bx
        push    ax
	call	_interrupt_handler
        pop     ax
        pop     bx
        mov     ss,ax
        mov     sp,bx
        pop     es
        add     sp,2
	pop	ds
	popa
	add	sp,2
	iret

;;; Default-Radix
global	_radix
_radix	equ	stackptr+56
