;;;   VPort-50 Monitor
;;;   Copyright (c) 2004, Hans Rosenfeld
;;;
;;;   This program is free software; you can redistribute it and/or modify
;;;   it under the terms of the GNU General Public License as published by
;;;   the Free Software Foundation; either version 2, or (at your option)
;;;   any later version.
;;;
;;;   This program is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;   GNU General Public License for more details.
;;;
;;;   You should have received a copy of the GNU General Public License
;;;   along with this program; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;;;   02111-1307, USA.

CPU 186
	
%include "seg.s"

;;; Programmstatus
global	_status
_status	equ	stackptr+28

;;; der Speicherbereich _status ist folgendermassen aufgeteilt:
%define	STATUS$AX	_status+0
%define STATUS$BX	_status+2
%define STATUS$CX	_status+4
%define STATUS$DX	_status+6
%define STATUS$SI	_status+8
%define STATUS$DI	_status+10
%define STATUS$DS	_status+12
%define STATUS$ES	_status+14
%define STATUS$CS	_status+16
%define STATUS$SS	_status+18
%define STATUS$PS	_status+20
%define STATUS$BP	_status+22
%define STATUS$SP	_status+24
%define STATUS$IP	_status+26

;;; Programm starten
global	_exec
_exec:	mov	ax,ss
	mov	ds,ax		; altes SS wird DS
	mov	ax,[STATUS$SS]	; neues SS setzen
	mov	ss,ax
	mov	sp,[STATUS$SP]	; dito fr SP
	push	word [STATUS$PS]
	push	word [STATUS$CS]
	push	word [STATUS$IP]; PS, CS und IP fr iret auf den Stack
	push    word [STATUS$AX]
	push    word [STATUS$CX]
	push    word [STATUS$DX]
	push    word [STATUS$BX]
	push    word [STATUS$SP]; wird von popa ignoriert
	push    word [STATUS$BP]
	push    word [STATUS$SI]
	push    word [STATUS$DI]; Register fr popa auf den Stack
	push	word [STATUS$DS]
	push    word [STATUS$ES]
	pop	es
	pop	ds
	popa
	iret
