/* VPort-50 Monitor
   Copyright (c) 2004, 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <common/string.h>
#include <common/stdio.h>
#include <mach/mach.h>
#include <mach/setjmp.h>

/* strncmps vergleicht die ersten len Zeichen der Strings s1 und s2
   bis zum Auftreten eines Zeichens aus ss
   gibt einen Integer kleiner, gleich oder grsser 0 zurck, je
   nachdem ob s1 kleiner, gleich oder grsser als s2 ist
   Annahme: s1 ist ein Literal, s2 eine Variable, strncmps("blah", var, 3)
*/
int strncmps(s1, s2, len, ss)
        char *s1, *s2, *ss;
        unsigned int len;
{
        register int c1, c2;
        DS_VAR(ds);

        do {
                CODE(ds);
                c1 = tolower(*s1++);
                RESTORE(ds);
                STACK(ds);
                c2 = tolower(*s2++);
                RESTORE(ds);
        } while(c1 && c2 && c1 == c2 && --len);

        /* c1 ist krzer als len, wenn s2 keine relevanten Zeichen mehr enthlt
           (skip gibt berspringt ein oder mehrere Zeichen) gehen wir davon aus
           dass die beiden Strings gleich genug sind
        */
        if(!c1 && ((s2-1) != skip((s2-1), ss)))
                return(0);
        return(c1 - c2);
}

/* skip gibt einen Zeiger auf das erste Zeichen in string zurck,
   das _nicht_ in chr enthalten ist.
   Annahme: string ist eine Variable, chr ein Literal
*/
char* skip(string, chr)
        char *string;
        char *chr;
{
        register int c1, c2;
        char *ptr;
        int match=1;
        DS_VAR(ds);
     
        if(!chr) return(string);

        STACK(ds);
        while(match && (c1 = tolower(*string++))) {
                RESTORE(ds);
                CODE(ds);
                match=0;
                ptr=chr;
                while(!match && (c2 = tolower(*ptr++)))
                        match=(c1 == c2);
                RESTORE(ds);
                STACK(ds);
        }
        RESTORE(ds);
        return(string-1);
}

/* berprft ob ein Zeichen eine gltige Hex-Ziffer ist */
int ishex(c)
        char c;
{
        if((c >= '0' && c <= '9') || 
           (c >= 'A' && c <= 'F') || 
           (c >= 'a' && c <= 'f')) 
                return(1);
        else return(0);
}

/* Konvertiert eine Hex-Ziffer in einen Integer */
int hex(c)
        char c;
{
        if(ishex(c))
                return((c > '9') ? ((c > 'Z') ? (c - 'a' + 10) : (c - 'A' + 10)) : (c - '0'));
        printf("%c%cnot Intel-Hex format\n", 7, 7);
        longjmp();
        /* NOTREACHED */
}

/* Konvertiert Grobuchstaben in Kleinbuchstaben */
int tolower(c)
        int c;
{
        return((c >= 'A' && c <= 'Z') ? c+32 : c);
}

