/* VPort-50 Monitor
   Copyright (c) 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <arm/setjmp.h>
#include <arm/status.h>
#include <arm/mach.h>
#include <arm/addr.h>
#include <arm/lpc2xxx.h>
#include <common/stdio.h>
#include <common/string.h>
#include <common/intel.h>

void setmem(addr_t addr, char mem[])
{
        int i;

        if(addr < 0x6000) {
                printf("%c%cwill not overwrite monitor code\n", 7, 7);
                longjmp();
        }
           
        if((addr >= 0x40000000) && (addr < 0x40000800)) {
                printf("%c%cwill not overwrite monitor data & stack\n", 7, 7);
                longjmp();
        }

        if(has_flash() && (addr < SRAM_START))
                write_flash(addr, mem);
        else for(i = 0; i != 512; i++)
                *((char *) (addr + i)) = mem[i]; 

}

void intel(addr_t *start)
{
        char buf[80], mem[512];
        char *ptr;
        unsigned int cnt, typ, val, sum, eflag=0, ofs=0;
        addr_t addr, next=0, eaddr=0;
     
loop:
        sum=0;
        printf("> ");
        ptr=gets(buf, 79);
        if(buf[0] != ':')
                goto error;

        cnt  = hex(buf[1]) << 4;
        cnt += hex(buf[2]);
        sum += cnt;

        addr  = hex(buf[3]) <<12;
        addr += hex(buf[4]) << 8;
        addr += hex(buf[5]) << 4;
        addr += hex(buf[6]);
        addr |= eaddr;
        sum += (addr&0xff00)>>8;
        sum += (addr&0x00ff);
     
        typ  = hex(buf[7]) << 4;
        typ += hex(buf[8]);
        sum += typ;
     
        ptr = buf + 9;
     
        switch(typ) {
        case IH_DATA: /* data record */
                if(!eflag)
                        goto exterror;
                
                if(addr < next)
                        goto unordered;

                if((addr & 0xfffff700) - (next & 0xfffff700)) {
                        if(ofs) {
                                while(ofs & 0x1ff) {
                                        mem[ofs++] = 0;
                                        inc_addr(&next);
                                }
                                setmem(next - 512, mem);
                                ofs = 0;
                        }
                        next = addr & 0xfffff700;
                }

                while(next != addr) {
                        mem[ofs++] = 0;
                        inc_addr(&next);
                }

                while(cnt--) {
                        val  = hex(*ptr++) << 4;
                        val += hex(*ptr++);
                        sum += val;
                        mem[ofs++] = val;
                        inc_addr(&addr);
                        if(ofs == 512) {
                                ofs = 0;
                                setmem(addr - 512, mem);
                        }
                }
                next = addr;
                break;

        case IH_END: /* end record */
                if(ofs) {
                        while(ofs & 0x1ff) {
                                mem[ofs++] = 0;
                                inc_addr(&next);
                        }
                        setmem(next - 512, mem);
                }               
                break;

        case IH_LSTART: /* start address record */
                *start = 0;
                *start += hex(*ptr++) << 28;
                *start += hex(*ptr++) << 24;
                *start += hex(*ptr++) << 20;
                *start += hex(*ptr++) << 16;
                *start += hex(*ptr++) << 12;
                *start += hex(*ptr++) << 8;
                *start += hex(*ptr++) << 4;
                *start += hex(*ptr++);
                sum += ((*start)&0xff000000) >> 24;
                sum += ((*start)&0x00ff0000) >> 16;
                sum += ((*start)&0x0000ff00) >> 8;
                sum += ((*start)&0x000000ff);
                break;

        case IH_LINADDR: /* extended linear address record */
                eaddr  = hex(*ptr++) << 12;
                eaddr += hex(*ptr++) << 8;
                eaddr += hex(*ptr++) << 4;
                eaddr += hex(*ptr++);
                sum += (eaddr&0xff00) >> 8;
                sum += (eaddr&0x00ff);
                eaddr <<= 16;
                eflag = 1;

                if(ofs) {
                        while(ofs & 511) {
                                mem[ofs++] = 0;
                                inc_addr(&next);
                        }
                        setmem(next - 512, mem);
                        ofs = 0;
                }               
                break;

        default:
                printf("%c%cillegal record type\n", 7, 7);
                longjmp();
        }
        val  = hex(*ptr++) << 4;
        val += hex(*ptr++);
        sum += val;
        if(sum&0xff) {
                printf("%c%cchecksum error\n", 7, 7);
                longjmp();
        }
        if(typ == 0x01)
                return;
        else goto loop;
      
error:
        printf("%c%cnot Intel-Hex format\n", 7, 7);
        longjmp();

exterror:
        printf("%c%cextended linear address not set\n", 7, 7);
        longjmp();

unordered:
        printf("%c%cdata not ordered\n", 7, 7);
        longjmp();
}
