/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#ifndef __TCU_H
#define __TCU_H

#define TCU_BASE 0x00d8
#define TCU_TCT0 (TCU_BASE)    /* Timer/Counter Register #0               */
#define TCU_TST0 (TCU_BASE)    /* Timer/Counter Status   #0               */
#define TCU_TCT1 (TCU_BASE+2)  /* Timer/Counter Register #1               */
#define TCU_TST1 (TCU_BASE+2)  /* Timer/Counter Status   #1               */
#define TCU_TCT2 (TCU_BASE+4)  /* Timer/Counter Register #2               */
#define TCU_TST2 (TCU_BASE+4)  /* Timer/Counter Register #2               */
#define TCU_TMD  (TCU_BASE+6)  /* Timer Mode Register                     */
#define TCU_TCKS 0xfff0        /* Timer Clock Selection Register          */

#define TCKS_PS04 0x0          /* Oscillating Frequency divided by  4     */
#define TCKS_PS08 0x1          /* Oscillating Frequency divided by  8     */
#define TCKS_PS16 0x2          /* Oscillating Frequency divided by 16     */
#define TCKS_PS32 0x3          /* Oscillating Frequency divided by 32     */
#define TCKS_CS0  0x4          /* TCU channel 0 clock selection, TCLK pin */
#define TCKS_CS1  0x8          /* TCU channel 1 clock selection, TCLK pin */
#define TCKS_CS2  0x10         /* TCU channel 2 clock selection, TCLK pin */

#define TMD_BCD      0x1       /* BCD count                               */
#define TMD_CMODE(x) (x<<1)    /* Counter Mode                            */
#define TMD_LATCH    (0x0<<4)  /* Counter Latch Command                   */
#define TMD_LOW      (0x1<<4)  /* Low order one byte                      */
#define TMD_HIGH     (0x2<<4)  /* High order one byte                     */
#define TMD_WORD     (0x3<<4)  /* Lower and higher order sequence 2 bytes */
#define TMD_TCT0     (0x0<<6)  /* TCT#0                                   */
#define TMD_TCT1     (0x1<<6)  /* TCT#1                                   */
#define TMD_TCT2     (0x2<<6)  /* TCT#2                                   */
#define TMD_MULT     (0x3<<6)  /* Multiple latch command                  */

extern void tcu_init();

#endif /* __TCU_H */
