;;;   VPort-50 Monitor
;;;   Copyright (c) 2004, Hans Rosenfeld
;;;
;;;   This program is free software; you can redistribute it and/or modify
;;;   it under the terms of the GNU General Public License as published by
;;;   the Free Software Foundation; either version 2, or (at your option)
;;;   any later version.
;;;
;;;   This program is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;   GNU General Public License for more details.
;;;
;;;   You should have received a copy of the GNU General Public License
;;;   along with this program; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;;;   02111-1307, USA.

CPU 186
	
;;; IO fr C-Funktionen, out(port,data) bzw. data=in(port)
;;; Achtung: data ist immer 8 Bit!
global	_out
_out:
	push	bp
	mov	bp,sp
	push	dx
	push	ax
	mov	dx,[bp+4]
	mov	ax,[bp+6]
	out	dx,al
	pop	ax
	pop	dx
	pop	bp
	ret

global	_in
_in:
	push	bp
	mov	bp,sp
	push	dx
	mov	dx,[bp+4]
	in	al,dx
	xor	ah,ah
	pop	dx
	pop	bp
	ret

;;; direkter Speicherzugriff fr C-Funktionen, lesend
;;; read_byte(seg, ofs) bzw. read_word(seg, ofs)
global	_read_byte
_read_byte:	
	push	bp
	mov	bp,sp
	push	ds
	push	bx
	mov	ax,[bp+4]
	mov	ds,ax
	mov	bx,[bp+6]
	mov	al,[bx]
	xor	ah,ah
	pop	bx
	pop	ds
	pop	bp
	ret
	
global	_read_word
_read_word:
	push	bp
	mov	bp,sp
	push	ds
	push	bx
	mov	ax,[bp+4]
	mov	ds,ax
	mov	bx,[bp+6]
	mov	ax,[bx]
	pop	bx
	pop	ds
	pop	bp
	ret

;;; direkter Speicherzugriff fr C-Funktionen, schreibend
;;; write_byte(seg, ofs, val) bzw. write_word(seg, ofs, val)
global	_write_word
_write_word:
	push	bp,
	mov	bp,sp
	push	ds
	push	bx
	mov	ax,[bp+4]
	mov	ds,ax
	mov	bx,[bp+6]
	mov	ax,[bp+8]
	mov	[bx],ax
	pop	bx
	pop	ds
	pop	bp
	ret

global	_write_byte
_write_byte:
	push	bp
	mov	bp,sp
	push	ds
	push	bx
	mov	ax,[bp+4]
	mov	ds,ax
	mov	bx,[bp+6]
	mov	ax,[bp+8]
	mov	[bx],al
	pop	bx
	pop	ds
	pop	bp
	ret

;;; sti/cli fr C-Funktionen, sti() u. cli()
global	_cli
_cli:	cli
	ret

global	_sti
_sti:	sti
	ret

;;; reset()
global	_reset
_reset:	jmp	0xf000:0xfff0
	
;;; imodu/idiv_u/imul_u/lcmpul/laddul fr C
global	imodu
imodu:	push	dx
	xor	dx,dx
	div	bx
	mov	ax,dx
	pop	dx
	ret

global	idiv_u
idiv_u:	push	dx
	xor	dx,dx
	div	bx
	pop	dx
	ret

global	imul_u
imul_u:	push	dx
	xor	dx,dx
	mul	bx
	pop	dx
	ret
	
global	lcmpul
lcmpul:	push	di
	push	bx
	mov	bx,di
	mov	di,[bx+2]
	pop	bx
	cmp	bx,di
	jnz	.out
	pop	di
	push	di
	mov	bx,di
	mov	di,[bx]
	cmp	ax,di
.out:	pop	di
	ret

global	laddul
laddul:	push	bx
	mov	bx,di
	mov	di,[bx]
        mov     si,[bx+2]
	pop	bx
	add	ax,di
	adc	bx,si
	ret

global	lslul
lslul:	push	cx
	mov	cx,di
.loop:  shl	ax,1
	rcl	bx,1
	loop	.loop
	pop	cx
	ret

;;; stack() und code() verndern das DS, restore() stellt es wieder her.
;;; Literale liegen im CS, der Zugriff erfolgt aber ber DS (Anwendungsfall
;;; code()), automatische Variablen liegen im SS, der Zugriff erfolgt aber
;;; auch ber DS (Anwendungsfall stack()).
;;; Beide Routinen geben den alten Wert von DS zurck, so dass dieser mittels
;;; restore() wiederhergestellt werden kann.

;;; unsigned int code(void)
global  _code
_code:  push    ds
        mov     ax,cs
        mov     ds,ax
        pop     ax
        ret
;;; unsigned int stack(void)
global  _stack
_stack: push    ds
        mov     ax,ss
        mov     ds,ax
        pop     ax
        ret

;;; void restore(unsigned int)
global  _restore
_restore:
        push    bp
        mov     bp,sp
        mov     ax,[bp+4]
        mov     ds,ax
        pop     bp
        ret