/   VPort-50 Monitor
/   Copyright (c) 2004, 2005 Hans Rosenfeld
/
/   This program is free software; you can redistribute it and/or modify
/   it under the terms of the GNU General Public License as published by
/   the Free Software Foundation; either version 2, or (at your option)
/   any later version.
/
/   This program is distributed in the hope that it will be useful,
/   but WITHOUT ANY WARRANTY; without even the implied warranty of
/   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/   GNU General Public License for more details.
/
/   You should have received a copy of the GNU General Public License
/   along with this program; if not, write to the Free Software
/   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
/   02111-1307, USA.

.globl	_monitor,_trap

br4 = 200
br5 = 240
br6 = 300
br7 = 340
	
.text
.=0^.

/ Eintrittspunkt an Adresse 0
.globl	_main
_main:
	jmp	start

/ Vektoren fr Traps und Interrupts
	trap; br7+0.	/ bus error
	trap; br7+1.	/ illegal instruction
	trap; br7+2.	/ breakpoint trap
	trap; br7+3.	/ input/output trap
	trap; br7+4.	/ power failure
	trap; br7+5.	/ EMT instruction
	trap; br7+6.	/ TRAP instruction
.=40^.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
.=240^.
	trap; br7+7.	/ programmed interrupt
	trap; br7+8.	/ floating point
	trap; br7+9.	/ segmentation violation
.=254^.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	dev;  br7+0.
	
.=400^.
/
/ Stack
/
.=1400^.
	
/ Maschine resetten, Stackpointer aufsetzen und monitor() aufrufen
.globl  _incr
start:
	reset
	mov	$start,sp
	mov	sp,-(sp)
	mov	(sp)+,r0
	sub	$start,r0
	neg	r0
	add	$6,r0
	mov	r0,_incr
	jsr	pc,_monitor
	
.globl	_reset
_reset:
	halt
	br	start

/ trap handler, ruft trap() mit den Registern
/ und der Ursache des Traps als Argument auf
trap:
	mfps	-(sp)
	bic	$!37,(sp)
	mov	sp,-(sp)
	mov	r5,-(sp)
	mov	r4,-(sp)
	mov	r3,-(sp)
	mov	r2,-(sp)
	mov	r1,-(sp)
	mov	r0,-(sp)
	jsr	pc,_trap
	mov	(sp)+,r0
	mov	(sp)+,r1
	mov	(sp)+,r2
	mov	(sp)+,r3
	mov	(sp)+,r4
	mov	(sp)+,r5
	tst	(sp)+
	tst	(sp)+
	rtt
	
/ setjmp(), longjmp() fr C
/ Achtung: im Gegensatz zu den blichen Versionen bentigen diese Funktionen
/ kein Argument, es steht genau ein Speicherbereich zur Verfgung
.globl	_jmpbuf

.globl	_setjmp,_longjmp
_setjmp:
	mfps	-(sp)		/ PSW auf den Stack
	bic	$!377,(sp)	/ Hi-Byte lschen
	mov	r0,-(sp)	/ R0 auf den Stack
	mov	$_jmpbuf,r0	/ Adresse von _jmpbuf in R0
	mov	(sp)+,(r0)+	/ altes R0 vom Stack in _jmpbuf
	mov	r1,(r0)+	/ Register in _jmpbuf sichern
	mov	r2,(r0)+
	mov	r3,(r0)+
	mov	r4,(r0)+
	mov	r5,(r0)+
	mov	sp,(r0)
	add	$4,(r0)+	/ korrigieren auf Zustand vorm Aufruf
	mov	(sp)+,(r0)+	/ PSW vom Stack in _jmpbuf
	mov	(sp),(r0)	/ PC vom Stack in _jmpbuf
	rts	pc

_longjmp:
	mov	$_jmpbuf+2,r0
	mov	(r0)+,r1	/ Register aus _jmpbuf holen
	mov	(r0)+,r2
	mov	(r0)+,r3
	mov	(r0)+,r4
	mov	(r0)+,r5
	mov	(r0)+,sp
	mov	(r0)+,-(sp)	/ PSW auf den (neuen!) Stack
	mov	(r0)+,-(sp)	/ PC auf den Stack
	mov	_jmpbuf,r0	/ R0 aus _jmbuf holen
	rti			/ und wie von einem Interrupt zurckkehren

/ Programm starten
/ Funktionsweise analog zu _longjmp
.globl  _status

.globl	_exec
_exec:
	mov	$_status+2,r0
	mov	(r0)+,r1
	mov	(r0)+,r2
	mov	(r0)+,r3
	mov	(r0)+,r4
	mov	(r0)+,r5
	mov	(r0)+,sp
	mov	(r0)+,-(sp)
	mov	(r0)+,-(sp)
	mov	_status,r0
	rtt

/ alle Interrupts, die wir selbst nicht verwenden, werden ignoriert
dev:
	rtt

/ Register retten und wiederherstellen
/ verwendet von jeder C-Funktion
/
/ Stack-Frame innerhalb von C-Funktionen:
/       +-------------------------+
/       | Rcksprungadresse       |
/       +-------------------------+
/ r5 -> | alter R5 (Framepointer) |
/       +-------------------------+
/       | Rckkehr-Overlay-Nummer |
/       +-------------------------+
/       | altes R4                |
/       +-------------------------+
/       | altes R3                |
/       +-------------------------+
/       | altes R2                |
/       +-------------------------+
/ sp -> |                         |
/        
.globl  csv
csv:    mov     r5,r1           / Rcksprungadresse sichern
        mov     sp,r5           / Framepointer setzen
        clr     -(sp)           / Overlay-Nummer ist immer 0, es gibt keine Overlays
        mov     r4,-(sp)        / Register retten
        mov     r3,-(sp)
        mov     r2,-(sp)
        jsr     pc,(r1)         / Rckkehr zum Aufrufer

.globl  cret
cret:   mov     r5,r2           / Framepointer holen
        tst     -(r2)           / Overlay-Nummer berspringen
        mov     -(r2),r4        / Register wiederherstellen
        mov     -(r2),r3
        mov     -(r2),r2
        mov     r5,sp           / Stackpointer wiederherstellen
        mov     (sp)+,r5        / alten Framepointer wiederherstellen
        rts     pc

/ vorzeichenlose Division
.globl  udiv
udiv:   mov     r1,-(sp)        / Divisor speichern
        mov     r0,r1           / DIV vorbereiten
        clr     r0
        div     (sp)+,r0        / dividieren, R0 = Quotient, R1 = Rest
        rts     pc

.globl  urem
urem:   mov     r1,-(sp)        / Divisor speichern
        mov     r0,r1           / DIV vorbereiten
        clr     r0
        div     (sp)+,r0        / dividieren, R0 = Quotient, R1 = Rest
        mov     r1,r0           / Rest zurckgeben
        rts     pc
