/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.

*/

#include <pdp11/cons.h>

/* solang keine weiteren Initialisierungen ntig sind,
   bleibt dieser Glue-Code hier
*/
void init()
{
        cons_init();
}

/* cons_init richtet die Konsole ein */
void cons_init()
{
        cons = (struct cons *) CONS_CSR;
        cons->rcsr = 0;
        cons->xcsr = 0;
}

/* Zeichen von der Konsole lesen, blockierend und nichtblockierend */
int getchar()
{
        register status, character;

        do {
                while((status = cons->rcsr&RCSR_DONE) == 0);
        } while(((character = cons->rbuf)&RBUF_ERROR));

        character &= 0177;
     
        if(character == '\r')
                character = '\n';

        return(character);
}

int getchar_nb()
{
        register status, character;

        if((status = cons->rcsr&RCSR_DONE) != 0)
                character = cons->rbuf;
        else
                character = -1;

        if(character&RBUF_ERROR)
                character = -1;

        if(character == '\r')
                character = '\n';
     
        return(character);
}

/* Zeichen auf die Konsole schreiben, blockierend */
void putchar(character)
        int character;
{
        character &= 0177;

        if(character == '\n')
                putchar('\r');
     
        while((cons->xcsr&XCSR_READY) == 0);
        cons->xbuf = character;
}
