/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#ifndef __COMMAND_H
#define __COMMAND_H

#define ILLEGAL    0
#define CMD_DUMP   1
#define CMD_SET    2
#define CMD_SHOW   3
#define CMD_RESET  4
#define CMD_INPUT  5
#define CMD_OUTPUT 6
#define CMD_MOVE   7
#define CMD_DISASM 8
#define CMD_START  9
#define CMD_CONT  10
#define CMD_HELP  11
#define CMD_CLR   12

#define CLR_BRK 1
#define CLR_CUR 2
#define CLR_REG 3

#define DEF_ADDR 1
#define DEF_PORT 2

#define SET_MEM 1
# define SET_MEM_A 3
# define SET_MEM_I 4
#  define SET_MEM_I_AUTO 5
#define SET_BRK 2
#define SET_REG 3
#define SET_TRC 4
#define SET_RAD 5

#define TRC_ON  1
#define TRC_OFF 2
#define TRC_TOG 3

#define SHO_CUR 1
#define SHO_PRM 2
#define SHO_BRK 3
#define SHO_REG 4
#define SHO_TRC 5

struct command {
        char* name;
        unsigned int cmd;
}; 

extern char* find_string();
#define find_command(t, s, c) find_string(t, s, c, 2)

#endif /* __COMMAND_H */
