/* VPort-50 Monitor
   Copyright (c) 2004, Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <common/break.h>
#include <mach/addr.h>
#include <mach/mach.h>

void dobreak()
{
        unsigned int i;
        DS_VAR(ds);

        STACK(ds);
        for(i=0; i!=brkcnt; i++) {
                if(i == brkcur)
                        continue;
                brktbl[i].inst = read_break(&brktbl[i].addr);
                write_break(&brktbl[i].addr, BRKINST);
        }

        RESTORE(ds);
}

void unbreak()
{
        unsigned int i;
        DS_VAR(ds);

        STACK(ds);
        for(i=0; i!=brkcnt; i++)
                if(read_break(&brktbl[i].addr) == BRKINST)
                        write_break(&brktbl[i].addr, brktbl[i].inst);
        RESTORE(ds);
}

void setbreak(addr)
        addr_t *addr;
{
        break_t temp;
        DS_VAR(ds);

        STACK(ds);
        temp = read_break(addr); /* try to read breakpoint location */
        write_break(addr, temp); /* try to write breakpoint location */
        cpy_addr(addr, &brktbl[brkcnt].addr);
        brkcnt++;
        RESTORE(ds);
}
