/* VPort-50 Monitor
   Copyright (c) 2004, 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#include <pdp11/mach.h>
#include <pdp11/addr.h>
#include <pdp11/setjmp.h>
#include <pdp11/status.h>
#include <common/command.h>
#include <common/string.h>
#include <common/stdio.h>
#include <common/break.h>

/* Kommando-Tabelle fr Register */
struct command c_reg[] = {
        "R0",  REG_R0,
        "R1",  REG_R1,
        "R2",  REG_R2,
        "R3",  REG_R3,
        "R4",  REG_R4,
        "R5",  REG_R5,
        "SP",  REG_SP,
        "PC",  REG_PC,
        "PSW", REG_PSW,
        0, 0
};

/* flagtab fr %F in printf */
struct flagtab flagtab[] = {
        001, 'C',
        002, 'V',
        004, 'Z',
        010, 'N',
        020, 'T',
        0, 0,
};

/* die PDP11 hat kein ROM, der Linker kann also frei entscheiden
   wo er globale Variable anordnet
*/
struct jmpbuf status, jmpbuf;
struct breakpoint brktbl[NBRK];
int brkcur, brkcnt, trace, radix;


/* showreg, clrreg, initreg - Register anzeigen, lvschen und initialisieren */
void showreg()
{
        register psw = trace ? status.psw : status.psw&0xffef;

        printf("\
R0 = %r, R1 = %r, R2 = %r, R3 = %r, R4 = %r, R5 = %r\n\
SP = %r, PC = %r, PSW = %r, %F\n",
               status.r0, status.r1, status.r2, status.r3, status.r4, status.r5,
               status.sp, status.pc, psw, psw);
}

void clrreg()
{
        status.r0 = status.r1 = status.r2 = status.r3 = status.r4 = status.r5 =
                status.sp = status.pc = status.psw = 0;
}

void initreg(addr)
        addr_t *addr;
{
        status.pc = *addr;
        status.sp = STACKPTR;
}
