/* VPort-50 Monitor
   Copyright (c) 2005 Hans Rosenfeld

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.
*/

#ifndef __BREAK_H
#define __BREAK_H

#include <mach/addr.h>
#include <mach/mach.h>

/* bei nderung von NBRK oder struct breakpoint _muss_ auch der
   Maschinen abhngige Teil der Breakpoint-Definitionen angepasst werden
*/
#define NBRK 10

extern struct breakpoint {
        addr_t addr;
        break_t inst;
} brktbl[NBRK];

extern int brkcnt;
extern int brkcur;
extern int trace;

extern void dobreak();
extern void unbreak();
extern void setbreak();

#endif /* __BREAK_H */
