/*  pokerd - a classical draw poker server
 *  Copyright (C) 2001,2003 Hans P. Rosenfeld <rosenfeld@grumpf.hope-2000.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 */

#ifndef __MAIN_H
#define __MAIN_H

#include "cards.h"
#include "player.h"
#include "check.h"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <signal.h>

#define DEF_PORT 65535
#define BUFSIZE 256

int init(int p);
void loop(int sock);
void removefd(int sock, int *maxfd, struct table_t *table, fd_set *fds);
void command(struct table_t *table, struct player_t **pplayer, char *buf, fd_set *fds, int *maxfd);

#endif

